% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_uniprot_data.R
\name{get_uniprot_data}
\alias{get_uniprot_data}
\title{Retrieve data from UniProt using UniProt's REST API}
\usage{
get_uniprot_data(
  query = NULL,
  columns = c("accession", "id", "gene_names", "organism_id", "reviewed"),
  print_url = FALSE,
  print_uniprot_messages = FALSE
)
}
\arguments{
\item{query}{list of keys corresponding to UniProt's query fields.
For example :
list("gene_exact" = c("Pik3r1", "Pik3r2") ,
"organism" = c("10090", "9606"), "reviewed" = "yes").
See `query_fields` for available query fields.}

\item{columns}{names of UniProt data columns to retrieve.
Examples include "accession", "id", "gene_names", "keyword", "sequence".
See `return_fields` for available return fields.}

\item{print_url}{Boolean. Prints the complete url used for the query.}

\item{print_uniprot_messages}{Boolean. Prints the raw error message returned
by UniProt.}
}
\value{
a list with the following items :
\describe{
  \item{url}{the query url}
  \item{messages}{messages returned by the REST API}
  \item{content}{a data.frame containing the query results}
}
}
\description{
Retrieve data from UniProt using UniProt's REST API
}
\examples{
#Getting gene names, keywords and protein sequences for a set of UniProt IDs.
ids <- c("P22682", "P47941")
cols <- c("accession", "id", "gene_names", "keyword", "sequence")
query = list("accession_id" = ids)
df <- get_uniprot_data(query = query, columns = cols)$content
df
}
