% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{quarto_use_template}
\alias{quarto_use_template}
\title{Use a custom format extension template}
\usage{
quarto_use_template(
  template,
  no_prompt = FALSE,
  quiet = FALSE,
  quarto_args = NULL
)
}
\arguments{
\item{template}{The template to install, either an archive or a GitHub
repository as described in the documentation
\url{https://quarto.org/docs/extensions/formats.html}.}

\item{no_prompt}{Do not prompt to confirm approval to download external extension.}

\item{quiet}{Suppress warnings and messages.}

\item{quarto_args}{Character vector of other \code{quarto} CLI flag pass to the
command. This is mainly for advanced usage, e.g it can be useful for new
options added to quarto CLI and not yet supported as function argument.}
}
\description{
Install and use a template for Quarto using \verb{quarto use}.
}
\examples{
\dontrun{
# Install a template and set up a draft document from a GitHub repository
quarto_use_template("quarto-journals/jss")

# Install a template and set up a draft document from a ZIP archive
quarto_use_template("https://github.com/quarto-journals/jss/archive/refs/heads/main.zip")
}

}
