% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aux-functions.R
\name{is.wholenumber}
\alias{is.wholenumber}
\title{Checks whether \code{x} contains integer numbers.}
\usage{
is.wholenumber(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{a vector to be checked for integers}

\item{tol}{an optional parameter specifying to which precision the check is
           to be performed.}
}
\value{
Returns a vector of logicals with the same length as \code{x}; each
        element \code{i} is \code{TRUE} iff \code{x[i]} is an integer.
}
\description{
Borrowed from the example in \code{\link[base]{integer}}.
}
\examples{
\dontrun{
is.wholenumber(1) # is TRUE
(x <- seq(1, 5, by = 0.5) )
is.wholenumber( x ) #-->  TRUE FALSE TRUE ...
}
}
\keyword{internals}

