% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{data_corpus_inaugural}
\alias{data_corpus_inaugural}
\title{US presidential inaugural address texts}
\format{
a \link{corpus} object with the following docvars:
\itemize{
\item \code{Year} a four-digit integer year
\item \code{President} character; President's last name
\item \code{FirstName} character; President's first name (and possibly middle initial)
}
}
\source{
\url{https://archive.org/details/Inaugural-Address-Corpus-1789-2009} and
\url{https://www.presidency.ucsb.edu/documents/presidential-documents-archive-guidebook/inaugural-addresses}.
}
\usage{
data_corpus_inaugural
}
\description{
US presidential inaugural address texts, and metadata (for the corpus), from
1789 to present.
}
\details{
\code{data_corpus_inaugural} is the \link{quanteda-package} corpus
object of US presidents' inaugural addresses since 1789. Document variables
contain the year of the address and the last name of the president.
}
\examples{
# some operations on the inaugural corpus
summary(data_corpus_inaugural)
head(docvars(data_corpus_inaugural), 10)
}
\keyword{data}
