% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{read_dict_functions}
\alias{read_dict_functions}
\alias{read_dict_lexicoder}
\alias{read_dict_wordstat}
\alias{read_dict_liwc}
\alias{read_dict_yoshikoder}
\title{Internal functions to import dictionary files}
\usage{
read_dict_lexicoder(path)

read_dict_wordstat(path, encoding = "auto")

read_dict_liwc(path, encoding = "auto")

read_dict_yoshikoder(path)
}
\arguments{
\item{path}{the full path and filename of the dictionary file to be read}

\item{encoding}{the encoding of the file to be imported}
}
\value{
a \pkg{quanteda} \link{dictionary} object
}
\description{
Internal functions to import dictionary files in a variety of formats

\code{read_dict_lexicoder} imports Lexicoder files in the \code{.lc3} format.

\code{read_dict_wordstat} imports WordStat files in the
\code{.cat} format.

\code{read_dict_liwc} imports LIWC dictionary files in the
\code{.dic} format.

\code{read_dict_yoshikoder} imports Yoshikoder files in the
\code{.ykd} format.
}
\examples{
dict <- quanteda:::read_dict_lexicoder(
    system.file("extdata", "LSD2015.lc3", package = "quanteda")
)


\dontrun{
dict <- quanteda:::read_dict_wordstat(system.file("extdata", "RID.cat", package = "quanteda"))
# dict <- read_dict_wordstat("/home/kohei/Documents/Dictionary/LaverGarry.txt", "utf-8")
# dict <- read_dict_wordstat("/home/kohei/Documents/Dictionary/Wordstat/ROGET.cat", "utf-8")
# dict <- read_dict_wordstat("/home/kohei/Documents/Dictionary/Wordstat/WordStat Sentiments.cat",
#                            encoding = "iso-8859-1")
}

dict <- quanteda:::read_dict_liwc(
    system.file("extdata", "moral_foundations_dictionary.dic", package = "quanteda")
)

dict <- quanteda:::read_dict_yoshikoder(system.file("extdata", "laver_garry.ykd",
                                                    package = "quanteda"))
}
\keyword{dictionary}
\keyword{internal}
