% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object-builder.R
\name{object-builders}
\alias{object-builders}
\alias{build_dfm}
\alias{rebuild_dfm}
\alias{upgrade_dfm}
\alias{build_tokens}
\alias{rebuild_tokens}
\alias{upgrade_tokens}
\alias{build_corpus}
\alias{rebuild_corpus}
\alias{upgrade_corpus}
\alias{build_dictionary2}
\alias{rebuild_dictionary2}
\alias{upgrade_dictionary2}
\title{Object compilers}
\usage{
build_dfm(
  x,
  features,
  docvars = data.frame(),
  meta = list(),
  class = "dfm",
  ...
)

rebuild_dfm(x, attrs)

upgrade_dfm(x)

build_tokens(
  x,
  types,
  padding = FALSE,
  docvars = data.frame(),
  meta = list(),
  class = "tokens",
  ...
)

rebuild_tokens(x, attrs)

upgrade_tokens(x)

build_corpus(x, docvars = data.frame(), meta = list(), class = "corpus", ...)

rebuild_corpus(x, attrs)

upgrade_corpus(x)

build_dictionary2(x, meta = list(), ...)

rebuild_dictionary2(x, attrs)

upgrade_dictionary2(x)
}
\arguments{
\item{x}{an input \link{corpus}, \link{dfm}, \link{tokens}, or \link{dictionary} object}

\item{features}{character for feature of resulting \code{dfm}}

\item{docvars}{data.frame for document level variables}

\item{meta}{list for meta fields}

\item{class}{class to be attached to the built object}

\item{...}{further objects passed to object metadata}

\item{attrs}{a list of attributes to be reassigned}

\item{types}{character for types of resulting `tokens`` object}

\item{padding}{logical indicating if the \code{tokens} object contains paddings}
}
\description{
Functions to build or re-build core objects, or to upgrade earlier versions
of these objects to the current format.
}
\keyword{internal}
