% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{qualpal}
\alias{qualpal}
\title{Generate qualitative color palettes}
\usage{
qualpal(n, colorspace = "pretty", ...)
}
\arguments{
\item{n}{The number of colors to generate. Has to lie between 2 and 50.}

\item{colorspace}{Either 1) a list of three named numeric vectors: \code{h}
(hue), \code{s} (saturation), and \code{l} (lightness), all of length 2
specifying a min and max value for the range. The values has to be in the
range -360 to 360 for \code{h}, and 0 to 1 for \code{s} and \code{l} 2), or
2) a \emph{character vector} specifying one of the predefined color spaces
(see below).}

\item{...}{Control parameters to pass on to the Nelder-Mead optimizer (see
\code{\link[dfoptim]{nmkb}}).}
}
\value{
qualpal returns a list of class "qualpal" with the following
  components. \item{hsl}{A matrix of the colors in the hsl color space.}
  \item{Lab}{A matrix of the colors in the CIE Lab color space.} \item{RGB}{A
  matrix of the colors in the sRGB color space.} \item{hex}{A character
  vector of the colors in hex notation.} \item{ciede2000}{A distance
  matrix of color differences according to the CIEDE 2000 formula.}
  \item{min_ciede2000}{The smallest pairwise CIEDE 2000 (the
  maximization objective of the optimizer.}
}
\description{
Takes a subset of the hsl color space and generates a qualitative color
palette by optimizing color difference via the CIEDE 2000 formula.
}
\details{
\code{qualpal} takes a color subspace in the hsl color space, where lightness
and saturation take values from 0 to 1. Hue take values from -360 to 360,
although negative values are brought to lie in the range \{0, 360\} under the
hood. This behavior exists to enable color subspaces that span any hue range
(since the hue range is circular).

The hsl color subspace is passed to a \emph{Nelder-Mead optimizer}:
(\code{dfoptim::nmkb}), which attempts to maximize the smallest pairwise
color difference among all \code{n} colors using the CIEDE 2000 color
difference algorithm. However, the optimizer gets easily stuck in local
minimi (since the optimization function is far from smooth) so multiple
restarts can be useful, particularly for high values of \code{n}.
}
\section{Predefined color spaces}{
 Instead of specifying a color space
  manually, the following predefined color spaces can by accessed by
  specifying their name as a character vector to \code{colorspace}.
  \describe{
  \item{\code{pretty}}{Tries to provide aesthetically pleasing, but still
  distinct color palettes. Hue ranges from 0 to 360, saturation from 0.1 to
  0.5, and lightness from 0.5 to 0.85. Does not handle large numbers of
  colors well.}
  \item{\code{pretty_dark}}{Like \code{pretty} but darker. Hue ranges from 0
  to 360, saturation from 0.1 to 0.5, and lightness from 0.2 to 0.4.}
  \item{\code{colorblind}}{Caters to red-green color blindness by
  simply avoiding most of the green hues. Hue ranges from -180 to 55,
  saturation from 0.1 to 0.6, and lightness from 0.2 to 0.85.}
  \item{\code{rainbow}}{Uses all hues, chromas, and most of the lightness
  range. Provides distinct, but not asethetically pleasing colors.}
  \item{\code{pastels}}{Pastel colors from the complete range of hues
  (0-360), with saturation between 0.2 and 0.4, and lightness between 0.8 and
  0.9.}
  }
}
\examples{
# generates 3 distinct colors from the default color subspace
qualpal(3)
qualpal(n = 3, list(h = c(35, 360), s = c(.5, .7), l = c(0, .45)))

# Trace the optimizer
qualpal(3, "colorblind", trace = TRUE)

# Rigorous (and slow) evaluation using control parameters of nmkb
\dontrun{
qualpal(6, "rainbow", maxfeval = 10000, tol = 1e-10)
}
\dontrun{
# The range of hue cannot exceed 360
qualpal(n = 3, list(h = c(-20, 360), s = c(.5, .7), l = c(0, .45)))
}
}
\seealso{
\code{\link{plot.qualpal}}, \code{\link{pairs.qualpal}},
  \code{\link[dfoptim]{nmkb}}
}

