% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_profile_lods.R
\name{add_pmap}
\alias{add_pmap}
\title{Add physical map contents to tibble}
\usage{
add_pmap(tib, pmap)
}
\arguments{
\item{tib}{a tibble with 3 columns: marker, trace, and profile lod values, typically outputted by calc_profile_lods()}

\item{pmap}{a physical map for a single chromosome}
}
\value{
a tibble with 4 columns: marker, trait, profile_lod, marker_position
}
\description{
Add physical map contents to tibble
}
\examples{
pm <- 1:3
names(pm) <- as.character(paste0('m', 1:3))
expand.grid(paste0('m', 1:3), paste0('m', 1:3)) \%>\%
    tibble::as_tibble() \%>\%
    dplyr::mutate(log10lik = rgamma(9, 5)) \%>\%
    calc_profile_lods() \%>\%
    add_pmap(pm)
}
\concept{profile lod tibble functions}
