% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_pvl.R
\name{boot_pvl}
\alias{boot_pvl}
\title{Perform bootstrap sampling and calculate test statistics for each bootstrap sample}
\usage{
boot_pvl(
  probs,
  pheno,
  addcovar = NULL,
  kinship = NULL,
  start_snp = 1,
  n_snp,
  pleio_peak_index,
  nboot = 1,
  max_iter = 10000,
  max_prec = 1/1e+08
)
}
\arguments{
\item{probs}{founder allele probabilities three-dimensional array for one chromosome only (not a list)}

\item{pheno}{n by d matrix of phenotypes}

\item{addcovar}{n by c matrix of additive numeric covariates}

\item{kinship}{a kinship matrix, not a list}

\item{start_snp}{positive integer indicating index within probs for start of scan}

\item{n_snp}{number of (consecutive) markers to use in scan}

\item{pleio_peak_index}{positive integer index indicating genotype matrix for bootstrap sampling. Typically acquired by using `find_pleio_peak_tib`.}

\item{nboot}{number of bootstrap samples to acquire and scan}

\item{max_iter}{maximum number of iterations for EM algorithm}

\item{max_prec}{stepwise precision for EM algorithm. EM stops once incremental difference in log likelihood is less than max_prec}
}
\value{
numeric vector of (log) likelihood ratio test statistics from `nboot_per_job` bootstrap samples
}
\description{
Create a bootstrap sample, perform multivariate QTL scan, and calculate log10 LRT statistic
}
\details{
Performs a parametric bootstrap method to calibrate test statistic values in the test of
pleiotropy vs. separate QTL. It begins by inferring parameter values at
the `pleio_peak_index` index value in the object `probs`. It then uses
these inferred parameter values in sampling from a multivariate normal
distribution. For each of the `nboot` sampled phenotype vectors, a two-dimensional QTL
scan, starting at the marker indexed by `start_snp` within the object
`probs` and extending for a total of `n_snp` consecutive markers. The
two-dimensional scan is performed via the function `scan_pvl_clean`. For each
two-dimensional scan, a log10 likelihood ratio test statistic is calculated. The
outputted object is a vector of `nboot` log10 likelihood ratio test
statistics from `nboot` distinct bootstrap samples.
}
\examples{

n <- 50
pheno <- matrix(rnorm(2 * n), ncol = 2)
rownames(pheno) <- paste0("s", 1:n)
colnames(pheno) <- paste0("tr", 1:2)
probs <- array(dim = c(n, 2, 5))
probs[ , 1, ] <- rbinom(n * 5, size = 1, prob = 0.2)
probs[ , 2, ] <- 1 - probs[ , 1, ]
rownames(probs) <- paste0("s", 1:n)
colnames(probs) <- LETTERS[1:2]
dimnames(probs)[[3]] <- paste0("m", 1:5)
boot_pvl(probs = probs, pheno = pheno,
        start_snp = 1, n_snp = 5, pleio_peak_index = 3, nboot = 1)


}
\references{
Knott SA, Haley CS (2000) Multitrait
least squares for quantitative trait loci detection.
Genetics 156: 899–911.

Walling GA, Visscher PM, Haley CS (1998) A comparison of
bootstrap methods to construct confidence intervals in QTL mapping.
Genet. Res. 71: 171–180.
}
