% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pheno.R
\name{read_pheno}
\alias{read_pheno}
\title{Read phenotype data}
\usage{
read_pheno(
  file,
  phenocovarfile = NULL,
  sep = ",",
  na.strings = c("-", "NA"),
  comment.char = "#",
  transpose = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{file}{Character string with path to the phenotype data file
(or a zip file containing both the phenotype and phenotype
covariate files).}

\item{phenocovarfile}{Character string with path to the phenotype
covariate file. This can be a separate CSV or zip file; if a zip
file, it must contain exactly one CSV file. Alternatively, if the
\code{file} argument indicates a zip file that contains two files
(phenotypes and phenotype covariates), then this
\code{phenocovarfile} argument must indicate the base name for the
phenotype covariate file.}

\item{sep}{the field separator character}

\item{na.strings}{a character vector of strings which are to be
interpreted as \code{NA} values.}

\item{comment.char}{A character vector of length one containing a
single character to denote comments within the CSV files.}

\item{transpose}{If TRUE, the phenotype data will be transposed. The
phenotype covariate information is \strong{never} transposed.}

\item{quiet}{If \code{FALSE}, print progress messages.}
}
\value{
Either a matrix of phenotype data, or a list containing
\code{pheno} (phenotype matrix) and \code{phenocovar} (phenotype
covariate matrix).
}
\description{
Read phenotype data from a CSV file (and, optionally, phenotype
covariate data from a separate CSV file). The CSV files may be
contained in zip files, separately or together.
}
\examples{
\dontrun{
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/Gough/gough_pheno.csv")
phe <- read_pheno(file)

phecovfile <- paste0("https://raw.githubusercontent.com/rqtl/",
                     "qtl2data/master/Gough/gough_phenocovar.csv")
phe_list <- read_pheno(file, phecovfile)
}
}
\seealso{
\code{\link[=read_cross2]{read_cross2()}},
sample data files at \url{https://kbroman.org/qtl2/pages/sampledata.html}
and \url{https://github.com/rqtl/qtl2data}
}
\keyword{IO}
