\name{replace.map}
\alias{replace.map}

\title{Replace the genetic map of a cross}

\description{
  Replace the map portion of a cross object.
}

\usage{replace.map(cross, map)}

\arguments{
 \item{cross}{An object of class \code{cross}.  See
   \code{\link[qtl]{read.cross}} for details.}
 \item{map}{A list containing the new genetic map.  This must be the
   same length and with the same marker names as that contained in
   \code{cross}. }
}

\value{The input \code{cross} object with the genetic map replaced by
  the input \code{map}.}

\author{Karl W Broman, \email{kbroman@jhsph.edu} }

\examples{
data(fake.f2)
newmap <- est.map(fake.f2)
plot.map(fake.f2,newmap)
fake.f2 <- replace.map(fake.f2, newmap)
}

\seealso{ \code{\link[qtl]{pull.map}}, \code{\link[qtl]{est.map}} }

\keyword{manip}
