% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{makecodechunk}
\alias{makecodechunk}
\title{makecodechunk}
\usage{
makecodechunk(
  cmd,
  opts = NULL,
  results = "asis",
  lang = "r",
  callout = NULL,
  h = NULL,
  w = NULL
)
}
\arguments{
\item{cmd}{character string vector of commands to run inside chunk}

\item{opts}{optional list of chunk options, e.g. \code{list(fig.width=6, fig.cap="This is a caption")}.  See \url{https://yihui.org/knitr/options/} for a complete list of options.}

\item{results}{format of results, default is \code{'asis'}.  May specify \code{results='markup'}.}

\item{lang}{language for the chunk}

\item{callout}{an optional Quarto callout to include after \verb{#|} after the chunk header that affects how the result appears, e.g. \code{callout='column: margin'}}

\item{h}{optional height to place after the chunk header after \verb{#|}}

\item{w}{optional width}
}
\value{
character vector
}
\description{
Create Text for Running Code Chunk
}
\details{
Creates text strings suitable for running through \code{knitr}.  The chunk is given a random name because certain operations are not allowed by \code{knitr} without it.
}
\examples{
makecodechunk('x <- pi; print(x)')
}
\author{
Frank Harrell
}
