% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{maketabs}
\alias{maketabs}
\title{maketabs}
\usage{
maketabs(
  ...,
  wide = FALSE,
  initblank = FALSE,
  baselabel = NULL,
  cap = NULL,
  basecap = NULL,
  debug = FALSE
)
}
\arguments{
\item{...}{a series of formulas or a single named list.  For formulas the left side is the tab label (if multiple words or other illegal R expressions enclose in backticks) and the right hand side has expressions to evaluate during chunk execution, plus optional \code{raw}, \code{caption}, and \code{fig.size} options.}

\item{wide}{set to \code{TRUE} to use a Quarto \code{column-page} for the body of the text to allow it to use some of the margins}

\item{initblank}{set to \code{TRUE} to create a first tab that is blank so that the report will not initially show any tabbed material}

\item{baselabel}{a one-word character string that provides the base name of \code{label}s for tabs with figure captions.  The sequential tab number is appended to \code{baselabel} to obtain the full figure label.  If using formulas the figure label may instead come from \code{caption(.., label)}. If not specified it is taken to be the name of the current chunk with \verb{fig-} prepended.}

\item{cap}{applies to the non-formula use of \code{maketabs} and is an integer vector specifying which tabs are to be given figure labels and captions.}

\item{basecap}{a single character string providing the base text for captions if \code{cap} is specified.}

\item{debug}{set to \code{TRUE} to output debugging information in file \verb{/tmp/z}}
}
\value{
nothing is returned; used to render markup
}
\description{
Make Quarto Tabs
}
\details{
Loops through a series of formulas or elements of a named list and outputs each element into
a separate \code{Quarto} tab.  A \code{wide} argument is used to expand the width
of the output outside the usual margins.  An \code{initblank} argument
creates a first tab that is empty, or you can specify a formula \verb{} ~ \verb{}.  This allows one to show nothing
until one of the other tabs is clicked.  Multiple commands can be run in one chunk by including multiple right hand terms in a formula.  A chunk can be marked for producing raw output by including a term \code{raw} somewhere in the formula's right side.  If can be marked for constructing a label and caption by including \verb{+ caption(caption string, label string)}.  The tab number is appended to the label string, and if the label is not provided \code{baselabel} will be used.
}
\examples{
X <- list(A=data.frame(x=1:2), B=data.frame(x=1:2, y=11:12))
maketabs(X)
}
\author{
Frank Harrell
}
