% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{getQLmodel}
\alias{getQLmodel}
\title{Setup the quasi-likelihood estimation model}
\usage{
getQLmodel(runs, lb, ub, obs, X = NULL, useVar = TRUE, criterion = "qle",
  ...)
}
\arguments{
\item{runs}{object of class \code{simQL} as simulation results from \code{\link{simQLdata}}}

\item{lb}{lower bounds defining the (hyper)box}

\item{ub}{upper bounds defining the (hyper)box}

\item{obs}{numeric vector of observed statistics}

\item{X}{matrix of sample locations (model parameters)}

\item{useVar}{logical, \code{TRUE} (default), whether to use prediction variances}

\item{criterion}{the criterion function to be minimized for parameter estimation (see \code{\link{qle}})}

\item{...}{arguments passed to \code{\link{fitSIRFk}} for fitting covariance models}
}
\value{
Object of class \code{\link{QLmodel}}
}
\description{
Setup the quasi-likelihood model data
}
\details{
The function is a wrapper to \code{\link{setQLdata}} and \code{\link{fitSIRFk}}
 in order to setup the data required for estimating the model parameters.
}
\examples{

data(normal)

# simulate model at a minimum of required design points
sim <- simQLdata(sim=qsd$sim,nsim=5,N=8,
			 method="maximinLHS",lb=qsd$lower,ub=qsd$upper)
	 
# true and error-free observation
obs <- structure(c("T1"=2,"T2"=1), class="simQL")

# construct QL approximation model
qsd <- getQLmodel(sim,qsd$lower,qsd$upper,obs,var.type="wcholMean")


}
\seealso{
\code{\link{simQLdata}}, \code{\link{QLmodel}}, \code{\link{fitSIRFk}}
}
\author{
M. Baaske
}
