% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{fitCov}
\alias{fitCov}
\title{Fitting covariance models by REML estimation}
\usage{
fitCov(models, Xs, data, controls = list(), cl = NULL, verbose = FALSE)
}
\arguments{
\item{models}{object either of class \code{krige}, a list of covariance models, or of
class \code{covModel}, that is, a single covariance model}

\item{Xs}{matrix of sample points, the design}

\item{data}{data frame of simulated sample means of statistics
first column corrsponds to the first model in the list `\code{models}` and so forth}

\item{controls}{list of control parameters, see \code{\link[nloptr]{nloptr}}}

\item{cl}{cluster object, \code{NULL} (default), see \code{\link[parallel]{makeCluster}}}

\item{verbose}{logical, \code{TRUE} for intermediate output}
}
\value{
An object of class \code{reml} which consists of a list of named lists
 (`\code{model}`, `\code{convergence}`) each storing a fitted covariance model itself
 together with the optimization results from \code{\link[nloptr]{nloptr}} as an attribute
 named `\code{optres}`. The default method for estimating the covariance parameters is \code{\link[nloptr]{mlsl}}.
}
\description{
The function estimates the (hyper)parameters of the covariance models by
	  the \emph{Restricted Maximum Likelihood} (REML) method.
}
\details{
The function fits a list of covariance models using the REML method. In order to avoid singularities
 of the so-called trend matrices make sure to use at least the minimum required number of sample points stored in
 `\code{Xs}` which depends on the defined trend order, see \code{\link{setCovModel}}.
}
\examples{
data(normal)  

# fit 1st statistic and get REML results
fitCov(qsd$covT[1],
       Xs=as.matrix(qsd$qldata[1:2]),
       data=qsd$qldata["mean.T1"],verbose=TRUE)
  
}
\seealso{
\code{\link{setCovModel}}
}
\author{
M. Baaske
}
