% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_bayes.R
\name{gmap}
\alias{gmap}
\title{Finemapping using Bayesian Linear Regression Models}
\usage{
gmap(
  y = NULL,
  X = NULL,
  W = NULL,
  stat = NULL,
  trait = NULL,
  sets = NULL,
  fit = NULL,
  Glist = NULL,
  chr = NULL,
  rsids = NULL,
  ids = NULL,
  b = NULL,
  bm = NULL,
  seb = NULL,
  mask = NULL,
  LD = NULL,
  n = NULL,
  vg = NULL,
  vb = NULL,
  ve = NULL,
  ssg_prior = NULL,
  ssb_prior = NULL,
  sse_prior = NULL,
  lambda = NULL,
  scaleY = TRUE,
  shrinkLD = FALSE,
  shrinkCor = FALSE,
  formatLD = "dense",
  pruneLD = TRUE,
  r2 = 0.05,
  checkLD = TRUE,
  h2 = NULL,
  pi = 0.001,
  updateB = TRUE,
  updateG = TRUE,
  updateE = TRUE,
  updatePi = TRUE,
  adjustE = TRUE,
  models = NULL,
  checkConvergence = FALSE,
  critVe = 3,
  critVg = 5,
  critVb = 5,
  critPi = 3,
  ntrial = 1,
  nug = 4,
  nub = 4,
  nue = 4,
  verbose = FALSE,
  msize = 100,
  threshold = NULL,
  ve_prior = NULL,
  vg_prior = NULL,
  tol = 0.001,
  nit = 100,
  nburn = 50,
  nit_local = NULL,
  nit_global = NULL,
  method = "bayesC",
  algorithm = "mcmc"
)
}
\arguments{
\item{y}{A vector or matrix of phenotypes.}

\item{X}{A matrix of covariates.}

\item{W}{A matrix of centered and scaled genotypes.}

\item{stat}{Dataframe with marker summary statistics.}

\item{trait}{Integer used for selection traits in covs object.}

\item{sets}{A list of character vectors where each vector represents a set of items. If the names
of the sets are not provided, they are named as "Set1", "Set2", etc.}

\item{fit}{List of results from gbayes.}

\item{Glist}{List of information about genotype matrix stored on disk.}

\item{chr}{Chromosome for which to fit BLR models.}

\item{rsids}{Character vector of rsids.}

\item{ids}{vector of individuals used in the study}

\item{b}{Vector or matrix of marginal marker effects.}

\item{bm}{Vector or matrix of adjusted marker effects for the BLR model.}

\item{seb}{Vector or matrix of standard error of marginal effects.}

\item{mask}{Vector or matrix specifying if marker should be ignored.}

\item{LD}{List with sparse LD matrices.}

\item{n}{Scalar or vector of number of observations for each trait.}

\item{vg}{Scalar or matrix of genetic (co)variances.}

\item{vb}{Scalar or matrix of marker (co)variances.}

\item{ve}{Scalar or matrix of residual (co)variances.}

\item{ssg_prior}{Scalar or matrix of prior genetic (co)variances.}

\item{ssb_prior}{Scalar or matrix of prior marker (co)variances.}

\item{sse_prior}{Scalar or matrix of prior residual (co)variances.}

\item{lambda}{Vector or matrix of lambda values}

\item{scaleY}{Logical indicating if y should be scaled.}

\item{shrinkLD}{Logical indicating if LD should be shrunk.}

\item{shrinkCor}{Logical indicating if cor should be shrunk.}

\item{formatLD}{Character specifying LD format (default is "dense").}

\item{pruneLD}{Logical indicating if LD pruning should be applied.}

\item{r2}{Scalar providing value for r2 threshold used in pruning}

\item{checkLD}{Logical indicating if LD matches summary statistics.}

\item{h2}{Trait heritability.}

\item{pi}{Proportion of markers in each marker variance class.}

\item{updateB}{Logical indicating if marker (co)variances should be updated.}

\item{updateG}{Logical indicating if genetic (co)variances should be updated.}

\item{updateE}{Logical indicating if residual (co)variances should be updated.}

\item{updatePi}{Logical indicating if pi should be updated.}

\item{adjustE}{Logical indicating if residual variance should be adjusted.}

\item{models}{List structure with models evaluated in bayesC.}

\item{checkConvergence}{Logical indicating if convergences should be checked.}

\item{critVe}{Scalar providing value for z-score threshold used in checking convergence for Ve}

\item{critVg}{Scalar providing value for z-score threshold used in checking convergence for Vg}

\item{critVb}{Scalar providing value for z-score threshold used in checking convergence for Vg}

\item{critPi}{Scalar providing value for z-score threshold used in checking convergence for Pi}

\item{ntrial}{Integer providing number of trials used if convergence is not obtaines}

\item{nug}{Scalar or vector of prior degrees of freedom for genetic (co)variances.}

\item{nub}{Scalar or vector of prior degrees of freedom for marker (co)variances.}

\item{nue}{Scalar or vector of prior degrees of freedom for residual (co)variances.}

\item{verbose}{Logical; if TRUE, it prints more details during iteration.}

\item{msize}{Integer providing number of markers used in computation of sparseld}

\item{threshold}{Scalar providing value for threshold used in adjustment of B}

\item{ve_prior}{Scalar or matrix of prior residual (co)variances.}

\item{vg_prior}{Scalar or matrix of prior genetic (co)variances.}

\item{tol}{Convergence criteria used in gbayes.}

\item{nit}{Number of iterations.}

\item{nburn}{Number of burnin iterations.}

\item{nit_local}{Number of local iterations.}

\item{nit_global}{Number of global iterations.}

\item{method}{Method used (e.g. "bayesN","bayesA","bayesL","bayesC","bayesR").}

\item{algorithm}{Specifies the algorithm.}
}
\value{
A list containing:
\itemize{
  \item{\code{bm}}{Vector or matrix of posterior means for marker effects.}
  \item{\code{dm}}{Vector or matrix of posterior means for marker inclusion probabilities.}
  \item{\code{vb}}{Scalar or vector of posterior means for marker variances.}
  \item{\code{vg}}{Scalar or vector of posterior means for genomic variances.}
  \item{\code{ve}}{Scalar or vector of posterior means for residual variances.}
  \item{\code{rb}}{Matrix of posterior means for marker correlations.}
  \item{\code{rg}}{Matrix of posterior means for genomic correlations.}
  \item{\code{re}}{Matrix of posterior means for residual correlations.}
  \item{\code{pi}}{Vector of posterior probabilities for models.}
  \item{\code{h2}}{Vector of posterior means for model probability.}
  \item{\code{param}}{List of current parameters used for restarting the analysis.}
  \item{\code{stat}}{Matrix of marker information and effects used for genomic risk scoring.}
}
}
\description{
In the Bayesian multiple regression model, the posterior density of the model parameters depends
on the likelihood of the data given the parameters and a prior probability for the model parameters.
The choice of the prior for marker effects can influence the type and extent of shrinkage induced in the model.
}
\details{
This function implements Bayesian linear regression models to provide unified mapping of 
genetic variants, estimate genetic parameters (e.g. heritability), and predict disease risk.
It is designed to handle various genetic architectures and scale efficiently with large datasets.
}
\examples{

# Plink bed/bim/fam files
bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")

# Prepare Glist
Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)

# Simulate phenotype
sim <- gsim(Glist=Glist, chr=1, nt=1)

# Compute single marker summary statistics
stat <- glma(y=sim$y, Glist=Glist, scale=FALSE)
str(stat)

# Define fine-mapping regions 
sets <- Glist$rsids
Glist$chr[[1]] <- gsub("21","1",Glist$chr[[1]]) 
Glist$chr[[2]] <- gsub("22","2",Glist$chr[[2]]) 

# Fine map
fit <- gmap(Glist=Glist, stat=stat, sets=sets, verbose=FALSE, 
            method="bayesC", nit=1500, nburn=500, pi=0.001)
            
fit$post  # Posterior inference for every fine-mapped region
fit$conv  # Convergence statistics for every fine-mapped region

# Posterior inference for marker effect
head(fit$stat)             

}
\author{
Peter Sørensen
}
