% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_bayes.R
\name{gbayes}
\alias{gbayes}
\title{Genomic prediction models implemented using Bayesian Methods (small data)}
\usage{
gbayes(
  y = NULL,
  W = NULL,
  sets = NULL,
  h2 = NULL,
  nsets = NULL,
  nsamp = 50,
  nburn = 10,
  nsave = 10000,
  tol = 0.001,
  method = "blasso",
  phi = c(0.999, 0.001)
)
}
\arguments{
\item{y}{is a matrix of phenotypes}

\item{W}{is a matrix of centered and scaled genotypes}

\item{sets}{is a list of markers defining a group}

\item{h2}{is the trait heritability}

\item{nsets}{is a list of number of marker groups}

\item{nsamp}{is the number of samples after burnin}

\item{nburn}{is the number of burnin samples}

\item{nsave}{is the number of samples to save}

\item{tol}{is the tolerance}

\item{method}{specifies the methods used (method="ssvs","blasso","blr")}

\item{phi}{is the proportion of markers in each marker variance class (phi=c(0.999,0.001),used if method="ssvs")}
}
\description{
Genomic prediction models implemented using Bayesian Methods (small data).
The models are implemented using empirical Bayesian methods. The hyperparameters of the dispersion parameters of the Bayesian model can
be obtained from prior information or estimated by maximum likelihood, and conditional on these, the model is fitted using
Markov chain Monte Carlo. These functions are currently under development and future release will be able to handle large data sets.
}
\examples{


# Simulate data and test functions

W <- matrix(rnorm(100000),nrow=1000)
set1 <- sample(1:ncol(W),5)
set2 <- sample(1:ncol(W),5)
sets <- list(set1,set2)
g <- rowSums(W[,c(set1,set2)])
e <- rnorm(nrow(W),mean=0,sd=1)
y <- g + e

gbayes(y=y, W=W, method="blasso", nsamp=50)
gbayes(y=y, W=W, method="ssvs", nsamp=50)
gbayes(y=y, W=W, method="blr", nsets=7, nsamp=50)

}
\author{
Peter Sørensen
}
