% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfratio-package.R
\docType{package}
\name{qfratio-package}
\alias{qfratio-package}
\title{qfratio: Moments and Distributions of Ratios of Quadratic Forms}
\description{
This package is for evaluating moments of ratios (and products) of quadratic
forms in normal variables, specifically using recursive algorithms developed
by Bao et al. (2013) and Hillier et al. (2014) (see also Smith, 1989, 1993;
Hillier et al., 2009).  It also provides some functions to evaluate
distribution and probability density functions of simple ratios of quadratic
forms in normal variables using several algorithms.  It was originally
developed as a supplement to Watanabe (2023) for evaluating
average evolvability measures in evolutionary quantitative genetics,
but can be used for a broader class of statistics.
}
\details{
The primary front-end functions of this package are
\code{\link{qfrm}()} and \code{\link{qfmrm}()} for evaluating moments of
ratios of quadratic forms.  These pass arguments to one of the several
\dQuote{internal} (though exported) functions which do actual calculations,
depending on the argument matrices and exponents.  In addition, there are
a few functions to calculate moments of products
of quadratic forms (integer exponents only; \code{\link{qfpm}}).

There are many internal functions for calculating coefficients in
power-series expansion of generating functions for these moments
(\code{\link{d1_i}}, \code{\link{d2_ij}}, \code{\link{d3_ijk}},
\code{\link{dtil2_pq}}) using \dQuote{super-short} recursions
(Bao and Kan, 2013; Hillier et al. 2014).  Some of these coefficients are
related to the top-order zonal and invariant
polynomials of matrix arguments.

The package also has some functions to evaluate distribution and
density functions of simple ratios of quadratic forms: \code{\link{pqfr}()}
and \code{\link{dqfr}()}.

See package vignettes (\code{vignette("qfratio")} and
\code{vignette("qfratio_distr")}) for more details.

The DESCRIPTION file:
\packageDESCRIPTION{qfratio}
\packageIndices{qfratio}
}
\section{Author/Maintainer}{

Junya Watanabe \href{mailto:jw2098@cam.ac.uk}{jw2098@cam.ac.uk}
}

\examples{
## Symmetric matrices
nv <- 4
A <- diag(nv:1)
B <- diag(sqrt(1:nv))
D <- diag((1:nv)^2 / nv)
mu <- nv:1 / nv
Sigma <- matrix(0.5, nv, nv)
diag(Sigma) <- 1

## Expectation of (x^T A x)^2 / (x^T x)^2 where x ~ N(0, I)
qfrm(A, p = 2)
## And a Monte Carlo mean of the same
mean(rqfr(1000, A = A, p = 2))

## Expectation of (x^T A x)^1/2 / (x^T x)^1/2 where x ~ N(0, I)
(res1 <- qfrm(A, p = 1/2))
plot(res1)
## A Monte Carlo mean
mean(rqfr(1000, A = A, p = 1/2))

## (x^T A x)^2 / (x^T B x)^3 where x ~ N(mu, Sigma)
(res2 <- qfrm(A, B, p = 2, q = 3, mu = mu, Sigma = Sigma))
plot(res2)
## A Monte Carlo mean
mean(rqfr(1000, A = A, B = B, p = 2, q = 3, mu = mu, Sigma = Sigma))

## Expectation of (x^T A x)^2 / (x^T B x) (x^T x) where x ~ N(0, I)
(res3 <- qfmrm(A, B, p = 2, q = 1, r = 1))
plot(res3)
## A Monte Carlo mean
mean(rqfmr(1000, A = A, B = B, p = 2, q = 1, r = 1))

## Expectation of (x^T A x)^2 where x ~ N(0, I)
qfm_Ap_int(A, 2)
## A Monte Carlo mean
mean(rqfp(1000, A = A, p = 2, q = 0, r = 0))

## Expectation of (x^T A x) (x^T B x) (x^T D x) where x ~ N(mu, I)
qfpm_ABDpqr_int(A, B, D, 1, 1, 1, mu = mu)
## A Monte Carlo mean
mean(rqfp(1000, A = A, B = B, D = D, p = 1, q = 1, r = 1, mu = mu))

## Distribution function and density of (x^T A x) / (x^T B x)
quantiles <- 0:nv + 0.5
pqfr(quantiles, A, B)
dqfr(quantiles, A, B)

}
\references{
Bao, Y. and Kan, R. (2013) On the moments of ratios of quadratic forms in
normal random variables. \emph{Journal of Multivariate Analysis}, \strong{117},
229--245.
\doi{10.1016/j.jmva.2013.03.002}.

Hillier, G., Kan, R. and Wang, X. (2009) Computationally efficient recursions
for top-order invariant polynomials with applications.
\emph{Econometric Theory}, \strong{25}, 211--242.
\doi{10.1017/S0266466608090075}.

Hillier, G., Kan, R. and Wang, X. (2014) Generating functions and
short recursions, with applications to the moments of quadratic forms
in noncentral normal vectors. \emph{Econometric Theory}, \strong{30}, 436--473.
\doi{10.1017/S0266466613000364}.

Smith, M. D. (1989) On the expectation of a ratio of quadratic forms
in normal variables. \emph{Journal of Multivariate Analysis}, \strong{31}, 244--257.
\doi{10.1016/0047-259X(89)90065-1}.

Smith, M. D. (1993) Expectations of ratios of quadratic forms in normal
variables: evaluating some top-order invariant polynomials.
\emph{Australian Journal of Statistics}, \strong{35}, 271--282.
\doi{10.1111/j.1467-842X.1993.tb01335.x}.

Watanabe, J. (2023) Exact expressions and numerical evaluation of average
evolvability measures for characterizing and comparing \strong{G} matrices.
\emph{Journal of Mathematical Biology}, \strong{86}, 95.
\doi{10.1007/s00285-023-01930-8}.
}
\seealso{
\code{\link{qfrm}}: Moment of simple ratio of quadratic forms

\code{\link{qfmrm}}: Moment of multiple ratio of quadratic forms

\code{\link{qfpm}}: Moment of product of quadratic forms

\code{\link{rqfr}}: Monte Carlo sampling of ratio/product of
quadratic forms

\code{\link{dqfr}}: Probability distribution of simple ratio of
quadratic forms
}
