% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qspec.lw}
\alias{qspec.lw}
\title{Lag-Window (LW) Estimator of Quantile Spectrum}
\usage{
qspec.lw(y.qacf, M = NULL)
}
\arguments{
\item{y.qacf}{matrix or array of pre-calculated QACF from \code{qdft2qacf()}}

\item{M}{bandwidth parameter of lag window (default = \code{NULL}: quantile periodogram)}
}
\value{
A list with the following elements:
  \item{spec}{matrix or array of quantile spectrum/cross-spectrum}
  \item{lw}{lag-window sequence}
}
\description{
This function computes lag-window (LW) estimate of quantile spectrum/cross-spectrum from QACF.
}
\examples{
# single time series
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qdft <- qdft(y1,tau)
y.qacf <- qdft2qacf(y.qdft)
y.qper.lw <- qspec.lw(y.qacf,M=5)$spec
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
qfa.plot(ff[sel.f],tau,Re(y.qper.lw[sel.f,]))
# multiple time series
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y.qdft <- qdft(cbind(y1,y2),tau)
y.qacf <- qdft2qacf(y.qdft)
y.qper.lw <- qspec.lw(y.qacf,M=5)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.lw[1,2,sel.f,]))
}
