% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network.R
\name{qtheme}
\alias{qtheme}
\alias{theme_nightheat}
\alias{theme_badkitchen}
\alias{theme_cafe}
\alias{theme_grayscale}
\alias{theme_greyscale}
\alias{theme_norah}
\alias{theme_hipster}
\alias{theme_duskheat}
\title{Add themes to a Network object.}
\usage{
qtheme(x = "generic", title, title.color, layout, legend, legend.cex,
  legend.text.color, legend.gradient, bg, vertex.color, vertex.size,
  vertex.frame.color, vertex.label.color, vertex.label.cex,
  edge.label.color, edge.label.cex)

theme_nightheat(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_badkitchen(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_cafe(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_grayscale(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_greyscale(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_norah(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_hipster(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)

theme_duskheat(x = pars[["x"]], title = pars[["title"]],
  title.color = pars[["title.color"]], layout = pars[["layout"]],
  legend = pars[["legend"]], legend.cex = pars[["legend.cex"]],
  legend.gradient = pars[["legend.gradient"]], bg = pars[["bg"]],
  legend.text.color = pars[["legend.text.color"]],
  vertex.color = pars[["vertex.color"]],
  vertex.size = pars[["vertex.size"]],
  vertex.frame.color = pars[["vertex.frame.color"]],
  vertex.label.color = pars[["vertex.label.color"]],
  vertex.label.cex = pars[["vertex.label.cex"]],
  edge.label.color = pars[["edge.label.color"]],
  edge.label.cex = pars[["edge.label.cex"]], ...)
}
\arguments{
\item{x}{The name of the qtheme.}

\item{title}{The title of the plot.  \code{NULL} eliminates title.  \code{NA}
uses title attribute of the Network object.}

\item{title.color}{The color of the title.}

\item{layout}{\pkg{igraph} \code{layout} to use.}

\item{legend}{The coordinates of the legend. See 
\code{\link[plotrix]{color.legend}} for more information.}

\item{legend.cex}{character expansion factor. \code{NULL} and \code{NA} are 
equivalent to 1.0. See \code{\link[graphics]{mtext}} for more information.}

\item{legend.text.color}{The text legend text color.}

\item{legend.gradient}{A vector of ordered colors to use for the gradient 
fills in the network edges.}

\item{bg}{The color to be used for the background of the device region. See
\code{\link[graphics]{par}} for more information.}

\item{vertex.color}{The font family to be used for vertex labels.}

\item{vertex.size}{The size of the vertex.}

\item{vertex.frame.color}{The color of the vertex border.}

\item{vertex.label.color}{The color of the labels.}

\item{vertex.label.cex}{The font size for vertex labels.}

\item{edge.label.color}{The color for the edge labels.  Use \code{NA} to 
remove.}

\item{edge.label.cex}{The font size of the edge labels.}

\item{\ldots}{Additional arguments supplied to \code{qtheme}.}
}
\description{
\code{qtheme} - This function builds generic themes to add a theme to a 
\code{Network} object rather than individual \code{print} arguments.

\code{theme_nightheat} A night heat theme.

\code{theme_badkitchen} A 70s kitchen theme.

\code{theme_cafe} A cafe theme.

\code{theme_grayscale} A grayscale theme.

\code{theme_norah} A Norah theme.

\code{theme_hipster} A hipster theme.

\code{theme_duskheat} A duskheat theme.
}
\examples{
\dontrun{
(poldat <- with(sentSplit(DATA, 4), polarity(state, person)))
m <- Network(poldat)
m

m + theme_nightheat
m + theme_cafe
m + theme_grayscale
m + theme_norah
m + theme_hipster
m + theme_badkitchen
m + theme_duskheat

## make your own themes
theme_irish <- qtheme(x = "irish", bg = "grey25", 
    vertex.label.color = "grey50", legend.text.color = "white",
    legend.gradient = c("darkgreen", "white", "darkorange"), 
    edge.label.color="white", vertex.size= 20)

m + theme_irish
}
}
