% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbldclass.R
\name{summary.qbld}
\alias{summary.qbld}
\alias{print.summary.qbld}
\title{QBLD Summary Class}
\usage{
\method{summary}{qbld}(object,quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975),epsilon = 0.05,...)

\method{print}{summary.qbld}(x, ...)
}
\arguments{
\item{object}{: `qbld' class object}

\item{quantiles}{: Vector of quantiles for summary of the covariates, 
defaulted to \code{c(0.025, 0.25, 0.5, 0.75, 0.975)}}

\item{epsilon}{: epsilon value for calculating significance stars (see details), 0.05 by default.}

\item{...}{: Other summary arguments}

\item{x}{: (for print.summary.qbld) `qbld.summary' class object}
}
\value{
summary.qbld produces following sets of summary statistics for each variable:
\itemize{
\item {\code{statistics:}} { Contains the mean, sd, markov std error, ess and Gelman-Rubin diagnostic}
\item {\code{quantiles:}}  { Contains quantile estimates for each variable}
\item {\code{nsim:}}       { No. of simulations run}
\item {\code{burn:}}       { Burn-in used or not}
\item {\code{which:}}      { Block, or Unblock version of sampler}
\item {\code{p:}}          { quantile for the AL distribution on the error term}
\item {\code{multiess:}}   { multiess value for the sample}
\item {\code{multigelman:}} { multivariate version of Gelman-Rubin}
}
}
\description{
Outputs a `summary.qbld' class object, and prints as described.
}
\details{
`qbld.summary' class summarizes the outputs of the model.qbld function. 
Markov Std Error (MCSE), Effective sample size (ESS) are calculated using mcmcse package. 
Gelman-Rubin diagnostic (R hat), and significance stars are indicated using Vats and Knudson et. al.
}
\references{
Vats, Dootika and Christina Knudson. “Revisiting the Gelman-Rubin Diagnostic.” arXiv 

James M. Flegal, John Hughes, Dootika Vats, and Ning Dai. (2020). mcmcse: Monte Carlo Standard Errors for MCMC. R
package version 1.4-1. Riverside, CA, Denver, CO, Coventry, UK, and Minneapolis, MN.

Christina Knudson and Dootika Vats (2020). stableGR: A Stable Gelman-Rubin Diagnostic for Markov Chain Monte Carlo. R
package version 1.0.
}
\seealso{
\code{\link{plot.qbld}}, \code{\link{model.qbld}}  

Additional functions : \code{\link[mcmcse]{mcse.mat}}, \code{\link[mcmcse]{ess}}, \code{\link[mcmcse]{multiESS}}, 
\code{\link[stableGR]{stable.GR}}, \code{\link[stableGR]{target.psrf}}
}
