% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable2.R
\name{px_map}
\alias{px_map}
\alias{px_map.px}
\title{MAP}
\usage{
px_map(x, value, validate)

\method{px_map}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string or data frame.
\itemize{
\item Use character to set MAP for all languages and STUB/HEADING
variables.
\item Use data frame with columns 'variable-code', 'language' and
'map' to set MAP for specific variables.
\item If missing, the current MAP is returned.
\item If NULL, MAP is removed for all variables.
}}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change MAP.
}
\examples{
# Set MAP for all languages
x1 <-
  px(population_gl) |>
  px_map('greenland')

# Print MAP
px_map(x1)

# Set MAP for individual variables
library(tibble)
x2 <-
  x1 |>
  px_map(tribble(~`variable-code`, ~map,
                    'gender', 'cities',
                    'age',    'municipalities'))
px_map(x2)

# Set MAP for individual languages
x3 <-
  x2 \%>\%
  px_languages(c('en', 'kl')) |>
  px_map(tribble(~`variable-code`, ~language, ~map,
                    'gender',    'en',      'cities_en',
                    'gender',    'kl',      'cities_kl',
                    'age',       'en',      'municipalities_en'))
px_map(x3)

# Remove MAP
x4 <- px_map(x3, NULL)
px_map(x4)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A49\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C354\%2C0\%5D}{Statistics Sweden's documentation}
}
