% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-calculation.R
\name{pwr.anova}
\alias{pwr.anova}
\title{Power of omnibus test}
\usage{
pwr.anova(design, alpha = 0.05, ...)
}
\arguments{
\item{design}{a design object created using design generating functions.}

\item{alpha}{significance level (type I error rate), default 0.05}

\item{...}{Additional arguments passed to \link[lmerTest]{anova.lmerModLmerTest}
for linear mixed models and to \link[car]{Anova} for linear models. The type
of sum of squares (SS, default is Type III) and the method for computing denominator
degrees of freedom (DDF, default is Satterthwaite's method) can be modified.
For balanced designs, types of SS and DDF do not affect results. Note that
these additional arguments should be consistent in the design-generating
function and \code{pwr.anova} for linear mixed models.}
}
\value{
a data frame with numerator degrees of freedom (NumDF), denominator
degrees of freedom (DenDF), non-centrality parameter, type I error rate (alpha),
and power.
}
\description{
Calculate power for testing overall effects of treatment factors and their
interactions, i.e., statistical power of ANOVA.
}
\examples{
# generate an RCBD
rcbd = designRCBD(treatments = c(2, 2), blocks = 10, beta = c(10, 9, 8, 7), VarCov = 10, sigma2 = 9)
# power of omnibus test
pwr.anova(rcbd, alpha  = 0.05)
}
\seealso{
\code{\link[=designCRD]{designCRD()}}, \code{\link[=designRCBD]{designRCBD()}}, \code{\link[=designLSD]{designLSD()}}, \code{\link[=designCOD]{designCOD()}}, \code{\link[=designSPD]{designSPD()}}, \code{\link[=designCustom]{designCustom()}}, and \code{\link[=pwr.contrast]{pwr.contrast()}}
}
