% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regint.R
\name{regint}
\alias{regint}
\title{Compute Power for Regression Interaction (Correlation/Coefficient Approach)}
\usage{
regint(Group1, Group2, sx1 = 1, sx2 = 1, sy1 = 1, sy2 = 1, nlow,
  nhigh, alpha = 0.05, Prop_n1 = 0.5, by = 2, Estimates = 1)
}
\arguments{
\item{Group1}{Estimates (r or b) for Group 1}

\item{Group2}{Estimates (r or b) for Group 2}

\item{sx1}{Standard deviation of predictor, group 1 (defaults to 1)}

\item{sx2}{Standard deviation of predictor, group 2 (defaults to 1)}

\item{sy1}{Standard deviation of outcome, group 1 (defaults to 1)}

\item{sy2}{Standard deviation of outcome, group 2 (defaults to 1)}

\item{nlow}{starting sample size}

\item{nhigh}{ending sample size}

\item{alpha}{Type I error (default is .05)}

\item{Prop_n1}{Proportion of Sample in First Group (defaults to equal sample sizes)}

\item{by}{incremental increase in sample (e.g. nlow = 10, nhigh = 24, by = 2, produces estimates of 10, 12, and 14)}

\item{Estimates}{1 for Correlations (default), 2 for coefficients}
}
\value{
Power for Regression Interaction (Correlation/Coefficient Approach)
}
\description{
Compute Power for Regression Interaction (Correlation/Coefficient Approach)
}
\examples{
regint(Group1=-.26,Group2=.25, alpha=.05,Prop_n1=0.5,nlow=110, nhigh=140,by=2,Estimates=1)
}
