% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{data}
\name{ICAP}
\alias{ICAP}
\title{Data set on \emph{Infrastructure Capital Stocks}}
\format{
A long-format data panel of class '\code{data.frame}', 
  where the columns \code{id_i} and \code{id_t} indicate the country and year 
  respectively. Column \code{COUNTRY} contains the complete country names.
}
\source{
The prepared data set is directly obtainable from the 
  \emph{ZBW Journal Data Archive}: \doi{10.15456/jae.2022321.0717368489}. 
  This is open data under the \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0 license}.
}
\usage{
data("ICAP")
}
\description{
The data set \code{ICAP} consists of annual observations for
  \itemize{
  \item the real GDP \eqn{Y} in US dollars, 
  \item the physical capital stocks \eqn{K} in US dollars,
  \item the physical capital stocks \eqn{KBC30} via "backcasting" in US dollars, 
  \item the number of workers \eqn{LWDI} providing the total labor force, and 
  \item the average years of secondary education \eqn{secondary} of the population. 
  }
  It further reports physical measures of infrastructure given by
  \itemize{
  \item the electricity generation capacity \eqn{EGC} in megawatts, 
  \item the number of main phone lines \eqn{mlines}, 
  \item the kilometers of total roads \eqn{troads}, 
  \item the number of cell phones lines \eqn{cells}, 
  \item the kilometers of paved roads \eqn{proads}, and 
  \item the kilometers of rails \eqn{rails}.
  }
  It covers the period 1960 to 2000 \eqn{(T=41)} for \eqn{N=97} countries.
  The monetary values are given in US-Dollars at 2000 prices, i.e. constant PPP.
}
\references{
Calderon, C., Moral-Benito, E., and Serven, L. (2015): 
  "Is Infrastructure Capital Productive? A Dynamic Heterogeneous Approach", 
  \emph{Journal of Applied Econometrics}, 30 (2), pp. 177-198.
}
\seealso{
Other data sets: 
\code{\link{ERPT}},
\code{\link{EURO}},
\code{\link{EU_w}},
\code{\link{MDEM}},
\code{\link{MERM}},
\code{\link{PCAP}},
\code{\link{PCIT}}
}
\concept{data sets}
\keyword{datasets}
