% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{conditional-map}
\alias{conditional-map}
\alias{map_at}
\alias{map_if}
\title{Modify elements conditionally}
\usage{
map_if(.x, .p, .f, ...)

map_at(.x, .at, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{.f}{A function, formula, or atomic vector.

  If a \strong{function}, it is used as is.

  If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a
  function with two arguments, \code{.x} or \code{.} and \code{.y}. This
  allows you to create very compact anonymous functions with up to
  two inputs.

  If \strong{character} or \strong{integer vector}, e.g. \code{"y"}, it
  is converted to an extractor function, \code{function(x) x[["y"]]}. To
  index deeply into a nested list, use multiple values; \code{c("x", "y")}
  is equivalent to \code{z[["x"]][["y"]]}. You can also set \code{.null}
  to set a default to use instead of \code{NULL} for absent components.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.at}{A character vector of names or a numeric vector of
positions. Only those elements corresponding to \code{.at} will be
modified.}
}
\value{
A list.
}
\description{
\code{map_if()} maps a function over the elements of \code{.x}
satisfying a predicate. \code{map_at()} is similar but will modify
the elements corresponding to a character vector of names or a
mumeric vector of positions.
}
\examples{
# Convert factors to characters
iris \%>\%
  map_if(is.factor, as.character) \%>\%
  str()

# Specify which columns to map with a numeric vector of positions:
mtcars \%>\% map_at(c(1, 4, 5), as.character) \%>\% str()

# Or with a vector of names:
mtcars \%>\% map_at(c("cyl", "am"), as.character) \%>\% str()

list(x = rbernoulli(100), y = 1:100) \%>\%
  transpose() \%>\%
  map_if("x", ~ update_list(., y = ~ y * 100)) \%>\%
  transpose() \%>\%
  simplify_all()

}

