% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{stops_nearby}
\alias{stops_nearby}
\title{Stops near a given location}
\usage{
stops_nearby(
  latitude,
  longitude,
  max_distance = NULL,
  route_types = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{latitude}{Numeric. Latitude in decimal degrees. For example, Flinders
Street Station is at approximately -37.8183 latitude.}

\item{longitude}{Numeric. Longitude in decimal degrees. For example, Flinders
Street Station is at approximately 144.9671 longitude.}

\item{max_distance}{Integer. Optionally filter by maximum distance from the
given location, in metres.}

\item{route_types}{Integer or character vector. Optionally filter by a vector
of route types. A route type can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the
\code{\link{route_types}} function to extract a vector of all route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item{\code{stop_id}}
\item{\code{stop_name}}
\item{\code{stop_suburb}}
\item{\code{route_type}}
\item{\code{route_type_description}}
\item{\code{stop_sequence}}
\item{\code{stop_latitude}}
\item{\code{stop_longitude}}
\item{\code{disruption_ids}}
}
}
\description{
Stops near a given location
}
\examples{
\dontrun{
stops_nearby(latitude = -37.8183, longitude = 144.9671)
stops_nearby(latitude = -37.8183, longitude = 144.9671, max_distance = 1000)
stops_nearby(
  latitude = -37.8183,
  longitude = 144.9671,
  route_types = c("Train", "Tram")
)

stops_nearby(
  latitude = -37.8183,
  longitude = 144.9671,
  route_types = 0
 )
}
}
