% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary.R
\name{shannon}
\alias{shannon}
\title{Compute Shannon Entropy}
\usage{
shannon(target, species, base = 2, alphabet = 21)
}
\arguments{
\item{target}{the KEGG identifier of the protein of interest.}

\item{species}{a character vector containing the KEGG code for the species of interest.}

\item{base}{integer that must take an allowed value: 2, 4 or 21 (see details).}

\item{alphabet}{a numeric value that can be either 21 or 4 (see details).}
}
\value{
Returns the computed entropy for each position of the molecular sequence of reference (both protein and cDNA sequences are considered).
}
\description{
Computes Shannon's entropies for both amino acid and codon positions
}
\details{
To compute the entropy at a given position in an amino acid alignment, we can consider an alphabet of 21 (20 amino acids plus the gap symbol, "-"), or alternatively an alphabet of 4 symbols when the amino acids are grouped according to their properties: charged (E,D,H,R,K), hydrophobic (A,L,I,V,M,F,W,Y), polar (S,T,C,Q,N) and special (G,P,-). The logarithm base used to compute the Shannon entropy can be set to 2 when we want to interpret the entropy in terms of bits, or it can be chosen to be  4 or 21 in order to get relative entropy values (ranging from 0 to 1) when we are using 4 or 21 letters alphabets, respectively. In the case of the codon entropy, we always use an alphabet of 62 codons. The logarithm base can be set to 2, in any other case it will take the value 62. Regarding the species included in the alingment, we can build the list of species or, alternatively, we can choose between pre-established options: 'vertebrates', 'plants', 'one-hundred', 'two-hundred'. The first will use the following seven species: human (hsa), chimp (ptr), gorilla (ggo), rat (rno), cow (bta), chicken (gga), western clawed frog (xtr) and zebrafish (dre). The second, A. thaliana (ara), A. lyrata (aly), B. oleracea (boe), G. max (gmax), S. lycopersicum (sly), O. sativa (osa) and C. reinhardtii (cre). The third and fourth options will use orthologous sequences from one hundred and two hundred different species, respectively.
}
\examples{
\dontrun{shannon('hsa:4069', 'vertebrates')}
}
\seealso{
msa(), custom.aln(), parse.hssp(), get.hssp()
}
\author{
Juan Carlos Aledo
}
