% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{env.plot}
\alias{env.plot}
\title{Differential Sequence Environment Plot}
\usage{
env.plot(Z, aa, pValue = 0.001, ylim = c(-8,6), ty = 'p',title = "")
}
\arguments{
\item{Z}{a matrix containing the standardized difference in frequencies (positive - control).}

\item{aa}{the amino acid of interest.}

\item{pValue}{the p-Value chosen to confer statistical significance.}

\item{ylim}{range of the dependent variable. If we pass the argument 'automatic', the function will choose a suitable range for you.}

\item{ty}{what type of plot should be drawn ("p": points, "l": lines, "b": both).}

\item{title}{character string giving a title for the plot.}
}
\value{
This function returns a plot for the requested amino acid.
}
\description{
Plots the Z statistics at each position within the environment for the requested amino acid.
}
\details{
The p-Value is used to draw two horizontal lines delimiting the region supporting the null hypothesis: no significant differences. Points laying above or below of these lines cannot be explained by randomness.
}
\examples{
\dontrun{## Get the matrices
pos = env.matrices(hmeto$positive)[[2]][,-11]
ctr = env.matrices(hmeto$control)[[2]][,-11]
## Run the test
Z = env.Ztest(pos, ctr, alpha = 0.0001)[[1]]
## Plot the results
env.plot(Z, aa = 'E', pValue = 0.05)}
}
\references{
Aledo et al. Sci Rep. 2015; 5: 16955. (PMID: 26597773)
}
\seealso{
env.extract(), env.matrices() and env.Ztest()
}
\author{
Juan Carlos Aledo
}
