% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgram.R
\name{pgram}
\alias{pgram}
\title{Periodogram computation}
\usage{
pgram(z, fr = "default", method = c("periodogram", "regression"))
}
\arguments{
\item{z}{time series vector of length n, say.}

\item{fr}{use "default" for usual Fourier frequencies, {1/n, ..., floor(n/2)/n}. 
Set fr = N, to evaluate the periodogram at the Fourier frequencies 
corresponding to a time series of length N. Finally set fr to any
desired set of frequencies. Note frequencies are in cycles per unit
time sometimes called temoral frequency to distinguish from angular
frequency. Both are widely used in time series.}

\item{method}{either periodogram or regression}
}
\value{
Periodogram evaluated at the Fourier frequencies or R-square.
}
\description{
The periodogram is computed.
}
\details{
Uses FFT.
So if the length of z is a highly composite number, the computation
is very efficient. Otherwise the usual DFT is used.
}
\examples{
z<-sunspot.year
n<-length(z) 
I<-pgram(z)
f<-I[,1]
I <- I[,2]
plot(f, I, xlab="f", ylab="f", type="l") 
title(main="Periodogram for Annual Sunpots, 1700-1988") 
#
z<-c(0.42, 0.89, 1.44, 1.98, 2.21, 2.04, 0.82, 0.62, 0.56, 0.8, 1.33)
fr <- (1:50)/101
pgram(z)
pgram(z, fr=101)
pgram(z, fr=fr)
pgram(z, method="regression")
pgram(z, method="regression", fr=101)
pgram(z, method="regression", fr=fr)
  
                                                        
}
\author{
A.I. McLeod and Yuanhao Lai
}
\keyword{ts}

