% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFitRobustG.R
\name{GetFitRobustG}
\alias{GetFitRobustG}
\title{Compute the Robust g test statistic}
\usage{
GetFitRobustG(y, freqSet = c("An", "En"))
}
\arguments{
\item{y}{Vector containing the series.}

\item{freqSet}{The set to search frequencies.}
}
\value{
Vector of length 2 containing the Robust g test statistic 
and the frequency for the maximum periodogram.
}
\description{
The Robust g test statistic is computed for testing for periodicity.
}
\details{
\code{An} refers to searching frequencies in the range 
twice as dense as the region of the fourier frequencies, i.e.,
\eqn{An = {0,1/n,\ldots,floor((2 n - 1)/2)/n}}.
\code{En} refers to searching frequencies in 
\eqn{En = {j/101 | j=1,\dots,50 and j/101 \ge 1/n}}.
}
\author{
Yuanhao Lai
}
\references{
Ahdesmaki, M., Lahdesmaki, H., Pearson, R., Huttunen, H., 
and Yli-Harja O.(2005). 
 \emph{BMC Bioinformatics} \bold{6}:117. 
 \url{http://www.biomedcentral.com/1471-2105/6/117}
}
\keyword{internal}

