% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Cc}
\alias{Cc}
\title{Microarray time series experiment for Caulobacter crescentus bacterial cell cycle}
\format{Matrix with 3062 rows and 11 columns.
Some missing data.
Rows and columns are labelled.
- attr(*, "dimnames")=List of 2
..$ : chr [1:3062] "ORF06244a" "ORF03152a" "ORF03156a" "ORF03161a" ...
..$ : chr [1:11] "1" "2" "3" "4" ...}
\usage{
data(Cc)
}
\description{
In this microarray experiment there are 3062 genes measured every 1 hour.
There are 19 is missing gene labels and these have been given 
labels ORFna1,...,ORFna19.
There 310 with duplicate labels.
Of these duplicate labels, 295 are duplicated twice, 12 are duplicated 3 times
and 3 are duplicated 4 times.
Duplicate labels are renamed ORF... to ORF...a and ORF...b etc.
}
\details{
Gene expression from synchronized cultures of the bacterium 
Caulobacter crescentus (Laub et al., 2000).
(Laub et al., 2000) identified 553 genes whose
messenger RNA levels varied as a function of the cell cycle but their
statistical analysis was not very sophisticated and they probably 
identified too many genes.
Wichert et al. (2004) found that 44 genes were found which displayed
periodicity based on the Fisher's g-test using a FDR with q=0.05.
}
\examples{
data(Cc)
qqnorm(colMeans(Cc, na.rm=TRUE))
qqnorm(rowMeans(Cc, na.rm=TRUE))
}
\references{
Laub, M.T., McAdams,H.H., Feldblyum,T., 
Fraser,C.M. and Shapiro,L. (2000) Global analysis of the genetic 
network controlling a bacterial cell cycle Science,
290, 2144-2148.

Wichert,S., Fokianos K. and Strimmer K. (2004) 
Identifying periodically expressed
transcrips in microarray time series data. Bioinformatics, 18, 5-20.
}
\keyword{datasets}

