% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error.R
\name{var_error_mult_R}
\alias{var_error_mult_R}
\alias{var_error_mult_Rsq}
\alias{var_error_R}
\alias{var_error_Rsq}
\title{Estimate the error variance of multiple correlations and squared multiple correlations for linear regressions}
\usage{
var_error_mult_R(R, n, p)

var_error_mult_Rsq(Rsq, n, p)

var_error_R(R, n, p)

var_error_Rsq(Rsq, n, p)
}
\arguments{
\item{R}{Vector of multiple correlation coefficients.}

\item{n}{Vector of sample sizes.}

\item{p}{Vector of numbers of predictors in the model.}

\item{Rsq}{Vector of squared multiple correlation coefficients.}
}
\value{
A vector of sampling-error variances.
}
\description{
Estimate the error variance of multiple correlations and squared multiple correlations for linear regressions
}
\details{
The sampling variance of a multiple correlation is approximately:

\deqn{var_{e}=\frac{(1-R^{2})^{2}(n-p-1)^{2}}{(n^{2}-1)(n+3)}}{var_e = (1 - R^2)^2 \* (n - p - 1)^2 / ((n^2 - 1) \* (n + 3))}

The sampling variance of a squared multiple correlation is approximately:

\deqn{var_{e}=\frac{4R^{2}(1-R^{2})^{2}(n-p-1)^{2}}{(n^{2}-1)(n+3)}}{var_e = 4 \* R^2 \* (1 - R^2)^2 \* (n - p - 1)^2 / ((n^2 - 1) \* (n + 3))}
}
\examples{
var_error_mult_R(R = .5, n = 30, p = 4)
var_error_mult_R(R = .5, n = 30, p = 4)
var_error_mult_Rsq(Rsq = .25, n = 30, p = 4)
var_error_mult_Rsq(Rsq = .25, n = 30, p = 4)
}
\references{
Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003).
\emph{Applied multiple regression/correlation analysis for the behavioral sciences} (3rd ed.).
Mahwah, NJ: Erlbaum. \url{https://doi.org/10/crtf}. p. 88.

Olkin, I., & Finn, J. D. (1995). Correlations redux.
\emph{Psychological Bulletin, 118}(1), 155–164. https://doi.org/10/bt48vd
}
