% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting-spl.R
\name{fit_ends_mods_spl}
\alias{fit_ends_mods_spl}
\title{Fit multiple spline regressions to the multiple required endpoints}
\usage{
fit_ends_mods_spl(
  simdat,
  knot_set = 1:3,
  scale_set = c("hazard", "odds", "normal"),
  expvar = NA
)
}
\arguments{
\item{simdat}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item ptid: patient identifier
\item pfs.durn: duration of PFS from baseline
\item pfs.flag: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item os.durn: duration of OS from baseline
\item os.flag: event flag for OS (=1 if death occurred, 0 for censoring)
\item ttp.durn: duration of TTP from baseline (usually should be equal to pfs.durn)
\item ttp.flag: event flag for TTP (=1 if progression occurred, 0 for censoring).
}

Survival data for all other endpoints (time to progression, pre-progression death, post-progression survival) are derived from PFS and OS.}

\item{knot_set}{is a vector of the numbers of knots to consider, following \code{\link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline()}}).}

\item{scale_set}{is a vector of the spline scales to consider, following \code{\link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline()}}).}

\item{expvar}{Explanatory variable for modeling of PPS}
}
\value{
A list by endpoint, then distribution, each containing two components:
\itemize{
\item result: A list of class \link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline} containing information about the fitted model.
\item error: Any error message returned on fitting the regression (NULL indicates no error).
Also, the given cuttime.
}
}
\description{
Fits multiple survival regressions, according to the distributions stipulated, to the multiple endpoints required in fitting partitioned survival analysis, clock forward and clock reset semi-markov models.
}
\examples{
\donttest{
# Create dataset in suitable form using bos dataset from the flexsurv package
bosonc <- create_dummydata("flexbosms")
fit_ends_mods_spl(bosonc, expvar=bosonc$ttp.durn)
}
}
\seealso{
Parametric modeling is handled by \code{\link[=fit_ends_mods_par]{fit_ends_mods_par()}}
}
