% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mivalext_lr.R
\name{mivalext_lr}
\alias{mivalext_lr}
\title{External Validation of logistic prediction models in MI datasets}
\usage{
mivalext_lr(data.val = NULL, data.orig = NULL, nimp = 5,
  impvar = NULL, Outcome, predictors = NULL, lp.orig = NULL,
  cal.plot = FALSE, plot.indiv = FALSE, val.check = FALSE, g = 10)
}
\arguments{
\item{data.val}{Data frame or data matrix with stacked multiple imputed validation datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1.}

\item{data.orig}{A single data frame or data matrix containing the original dataset
that was used to develop the model. Used to estimate the original regression
coefficients in case lp.orig is not provided.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{predictors}{Character vector with the names of the predictor variables
of the model that is validated.}

\item{lp.orig}{Numeric vector of the original coefficient values that are
externally validated.}

\item{cal.plot}{If TRUE a calibration plot is generated. Default is FALSE.}

\item{plot.indiv}{If TRUE calibration plots of each imputed dataset are
generated. Default is FALSE.}

\item{val.check}{logical vector. If TRUE the names of the predictors of the LP
are provided and can be used as information for the order of the coefficient
values as input for lp.orig. If FALSE (default) validation procedure is executed
with coefficient values fitted in the order as used under lp.orig.}

\item{g}{A numerical scalar. Number of groups for the Hosmer and
Lemeshow test. Default is 10.}
}
\value{
A \code{mivalext_lr} object from which the following objects 
 can be extracted: ROC results as \code{ROC}, R squared results (fixed and calibrated) 
 as \code{R2 (fixed)} and \code{R2 (calibr)}, Hosmer and Lemeshow test as \code{HL_test}, 
 coefficients pooled as \code{coef_pooled}, linear predictor pooled as \code{LP_pooled ext}, 
 and \code{Outcome}, \code{nimp}, \code{impvar}, \code{val.check}, 
 \code{g} and \code{coef.check}.
}
\description{
\code{mivalext_lr} External validation of logistic prediction models
}
\details{
The following information of the externally validated model is provided:
 pooled ROC curve (median and backtransformed after pooling log transformed
 ROC curves), pooled Nagelkerke R-Square value (median and backtransformed
 after pooling Fisher transformed values), pooled Hosmer and Lemeshow Test (using
 miceadds package), pooled coefficients when model is freely estimated in imputed
 datasets and the pooled linear predictor (LP), after the externally validated LP
 is estimated in each imputed dataset (provides information about miscalibration
 in intercept and slope). When the external validation is very poor,
 the R2 fixed can become negative due to the poor fit of the model in
 the external dataset (in that case you may report a R2 of zero).
}
\examples{
mivalext_lr(data.val=lbpmilr, nimp=10, impvar="Impnr", Outcome="Chronic",
predictors=c("Gender", "factor(Carrying)", "Function", "Tampascale",  "Age"),
lp.orig=c(-9.2, -0.34, 0.92, 1.5, 0.5, 0.26, -0.02),
cal.plot=TRUE, plot.indiv=TRUE, val.check = TRUE)

mivalext_lr(data.val=lbpmilr, nimp=5, impvar="Impnr", Outcome="Chronic",
predictors=c("Gender", "factor(Carrying)", "Function", "Tampascale", "Age"),
lp.orig=c(-9.2, -0.34, 0.92, 1.1, -0.05, 0.26, -0.02),
cal.plot=TRUE, plot.indiv=TRUE, val.check = FALSE)

}
\references{
F. Harrell. Regression Modeling Strategies. With Applications to
 Linear Models, Logistic and Ordinal Regression, and Survival Analysis. Springer,
 New York, NY, 2015.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman &
 Hall/CRC Interdisciplinary Statistics. Boca Raton.

http://missingdatasolutions.rbind.io/
}
