% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseval-constructors.R
\name{add_bootstrap}
\alias{add_bootstrap}
\title{Bootstrap resampling parameters}
\usage{
add_bootstrap(psdesign, bootstrap)
}
\arguments{
\item{psdesign}{A psdesign object, it must have risk model and integration model components}

\item{bootstrap}{A bootstrap object created by \link{ps_bootstrap}}
}
\description{
Bootstrap resampling parameters
}
\examples{
\dontrun{
test <- psdesign(generate_example_data(n = 100), Z = Z, Y = Y.obs, S = S.obs, BIP = BIP)
est1 <- test + integrate_parametric(S.1 ~ BIP) + risk_binary() + ps_estimate(method = "BFGS")
est1 + ps_bootstrap(method = "BFGS", start = est1$estimates$par, n.boots = 50)
}
}
