% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plr.R
\name{plr}
\alias{plr}
\title{Polygonal linear regression}
\usage{
plr(formula, env, residuals_type = "mse", intercept = TRUE)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{env}{environment that contain the variables of study.}

\item{residuals_type}{type of residual, e.g., rmsd and mse residuals by area.}

\item{intercept}{logical, if TRUE the model present intercept, otherwise it do not present intercept.}
}
\value{
beta_hat a vector of estimators for beta proposed in model.

SSRES sum square residuals.

SSREG sum square of regressions.

SST sum square toral.

residuals_type a type of residuals mse or rmsd.

prediction_polygons a list of prediction polygons by plr model.
}
\description{
plr is used to fit polygonal linear models.
}
\examples{
require(psda)
yp <- psim(10, 4)
xp1 <- psim(10, 4)
xp2 <- psim(10, 4)
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1+xp2, env = e)
}
