% Generated by roxygen2 (4.0.1): do not edit by hand
\name{make_function}
\alias{make_function}
\title{Make a function from its components.}
\usage{
make_function(args, body, env = parent.frame())
}
\arguments{
\item{args}{A named list of default arguments.  Note that if you want
arguments that don't have defaults, you'll need to use the special function
\code{\link{alist}}, e.g. \code{alist(a = , b = 1)}}

\item{body}{A language object representing the code inside the function.
Usually this will be most easily generated with \code{\link{quote}}}

\item{env}{The parent environment of the function, defaults to the calling
environment of \code{make_function}}
}
\description{
This constructs a new function given it's three components:
list of arguments, body code and parent environment.
}
\examples{
f <- function(x) x + 3
g <- make_function(alist(x = ), quote(x + 3))

# The components of the functions are identical
identical(formals(f), formals(g))
identical(body(f), body(g))
identical(environment(f), environment(g))

# But the functions are not identical because f has src code reference
identical(f, g)

attr(f, "srcref") <- NULL
# Now they are:
stopifnot(identical(f, g))
}

