% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDecoyDB.R
\name{createDecoyDB}
\alias{createDecoyDB}
\title{create db with decoys and contaminants}
\usage{
createDecoyDB(dbs, useContaminants = TRUE, revLab = "REV_",
  annot = "zz|sourceOf|database")
}
\arguments{
\item{dbs}{a path to a fasta file or an array of files}

\item{useContaminants}{add fgcz contaminants}

\item{revLab}{label for reversed peptides (if NULL do not generate decoys)}

\item{annot}{source of database}
}
\description{
create db with decoys and contaminants
}
\examples{
file = file.path(path.package("prozor"),"extdata/uniprot_taxonomy_Oryctolagus_cuniculus.fasta.gz")
cont <- loadContaminantsFasta()
rabbit <-readPeptideFasta(file)
tmp <- 2*(2*length(rabbit)+length(cont)) + 1

res <- createDecoyDB(c(file,file))
length(res)
tmp
stopifnot(length(res) == tmp)

res <- createDecoyDB(c(file,file), revLab=NULL)
stopifnot(length(res) == (2*length(rabbit)+length(cont) + 1))
res <- createDecoyDB(c(file,file), revLab=NULL, useContaminants = FALSE)
stopifnot(length(res) == (2*length(rabbit) + 1) )

}
