% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_chebis.R
\name{find_chebis}
\alias{find_chebis}
\title{Find ChEBI IDs for name patterns}
\usage{
find_chebis(chebi_data, pattern)
}
\arguments{
\item{chebi_data}{A data frame that contains at least information on ChEBI IDs (id) and their names (name).
This data frame can be obtained by calling \code{fetch_chebi()}. Ideally this should be subsetted to only contain molecules of a specific type e.g. metals.
This can be achieved by calling \code{find_all_subs} with a general ID such as "25213" (Metal cation) and then subset the complete ChEBI database to only include the returned sub-IDs.
Using a subsetted database ensures better search results. This is a helper function for other functions.}

\item{pattern}{A character vector that contains names or name patterns of molecules. Name patterns can be for example obtained with the \code{split_metal_name} function.}
}
\value{
A list of character vectors containing ChEBI IDs that have a name matching the supplied pattern.
}
\description{
A list of ChEBI IDs that contain a specific name pattern is returned.
}
