% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peptide.R
\name{find_peptide}
\alias{find_peptide}
\title{Find peptide location}
\usage{
find_peptide(data, protein_sequence, peptide_sequence)
}
\arguments{
\item{data}{A data frame containing at least the protein and peptide sequence.}

\item{protein_sequence}{The name of the column containing the protein sequence.}

\item{peptide_sequence}{The name of the column containing the peptide sequence.}
}
\value{
A data frame that contains the input data and four additional columns with start and end position, the last amino acid and the amino acid before.
}
\description{
The position of the given peptide sequence is searched within the given protein sequence. In addition the last amino acid of the peptide and the amino acid right before are reported.
}
\examples{
data <- data.frame(protein_sequence = c("abcdefg"), peptide_sequence = c("cde"))
find_peptide(data, protein_sequence, peptide_sequence)
}
