% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-propd.R, R/5-propdCall.R
\docType{class}
\name{propd}
\alias{propd}
\alias{propd-class}
\alias{show,propd-method}
\alias{propd}
\alias{setActive}
\alias{setDisjointed}
\alias{setEmergent}
\alias{updateCutoffs.propd}
\alias{updateF}
\title{The propd Method}
\usage{
\S4method{show}{propd}(object)

propd(counts, group, alpha, p = 100, weighted = FALSE)

setActive(propd, what = "theta_d")

setDisjointed(propd)

setEmergent(propd)

updateCutoffs.propd(object, cutoff = seq(0.05, 0.95, 0.3))

updateF(propd, moderated = FALSE, ivar = "clr")
}
\arguments{
\item{object}{A \code{propr} or \code{propd} object.}

\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns.}

\item{group}{A character vector. Group or sub-group memberships,
ordered according to the row names in \code{counts}.}

\item{alpha}{A double. See vignette for details. Leave missing
to skip Box-Cox transformation.}

\item{p}{An integer. The number of permutation cycles.}

\item{weighted}{A boolean. Toggles whether to calculate
theta using \code{limma::voom} weights.}

\item{propd}{A \code{propr} or \code{propd} object.}

\item{what}{A character string. The theta type to set active.}

\item{cutoff}{For \code{updateCutoffs}, a numeric vector.
this argument provides the FDR cutoffs to test.
For graph functions, a numeric scalar. This argument
indicates the maximum theta to include in the figure.
For graph functions, a large integer will instead
retrieve the top N pairs as ranked by theta.}

\item{moderated}{For \code{updateF}, a boolean. Toggles
whether to calculate a moderated F-statistic.}

\item{ivar}{A numeric scalar. Specifies reference feature(s)
for additive log-ratio transformation. The argument will also
accept feature name(s) instead of the index position(s).
Set to "iqlr" to use inter-quartile log-ratio transformation.
Ignore to use centered log-ratio transformation.}
}
\value{
Returns a \code{propr} object.
}
\description{
Welcome to the \code{propd} method!

Let \eqn{X} and \eqn{Y} be non-zero positive feature vectors
 measured across \eqn{N} samples belonging to one of two groups,
 sized \eqn{N1} and \eqn{N2}. We use VLR to denote the variance
 of the log of the ratio of the vectors \eqn{X} over \eqn{Y}.
 We define theta as the weighted sum of the within-group VLR
 divided by the weighted total VLR.

The \code{propd} method calculates theta. This fails in
 the setting of zero counts. The \code{propd} method
 will use a Box-Cox transformation to approximate VLR based on
 the parameter \eqn{\alpha}, if provided. We refer the user to
 the vignette for more details.

Note that Group 1 always refers to the first element of the
 \code{group} vector argument supplied to \code{propd}.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A data.frame. Stores the original "count matrix" input.}

\item{\code{alpha}}{A double. Stores the alpha value used for transformation.}

\item{\code{group}}{A character vector. Stores the original group labels.}

\item{\code{weighted}}{A logical. Stores whether the theta is weighted.}

\item{\code{weights}}{A matrix. If weighted, stores the limma-based weights.}

\item{\code{active}}{A character. Stores the name of the active theta type.}

\item{\code{Fivar}}{ANY. Stores the reference used to moderate theta.}

\item{\code{dfz}}{A double. Stores the prior df used to moderate theta.}

\item{\code{results}}{A data.frame. Stores the pairwise \code{propd} measurements.}

\item{\code{permutes}}{A data.frame. Stores the shuffled group labels,
used to reproduce permutations of \code{propd}.}

\item{\code{fdr}}{A data.frame. Stores the FDR cutoffs for \code{propd}.}
}}

\section{Methods (by generic)}{

\code{show:} Method to show \code{propd} object.
}

\section{Functions}{

\code{setActive:}
 Build analyses and figures using a specific theta type. For
 example, set \code{what = "theta_d"} to analyze disjointed
 proportionality and \code{what = "theta_e"} to analyze
 emergent proportionality.


\code{setDisjointed:}
 A wrapper for \code{setActive(propd, what = "theta_d")}.


\code{setEmergent:}
 A wrapper for \code{setActive(propd, what = "theta_e")}.


\code{updateCutoffs:}
 Use the \code{propd} object to permute theta across a
 number of theta cutoffs. Since the permutations get saved
 when the object is created, calling \code{updateCutoffs}
 will use the same random seed each time.


\code{updateF:}
 Use the \code{propd} object to calculate the F-statistic
 from theta as described in the Erb et al. 2017 manuscript
 on differential proportionality. Optionally calculates a
 moderated F-statistic using the limma-voom method. Supports
 weighted and alpha transformed theta values.
}

