% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_annoy_model}
\alias{get_annoy_model}
\title{Build Annoy model}
\usage{
get_annoy_model(vectors, number_trees)
}
\arguments{
\item{vectors}{\link{matrix} where each row is an observation. \link{rownames} should contain textual versions of the vectors.}

\item{number_trees}{\link{integer} counting the number of trees to grow in Annoy (for neighbor search). More gives better results but is slower to compute.}
}
\description{
\link{RcppAnnoy} model is used to retrieve the most similar vectors to a pivot one.
This function builds the \link{RcppAnnoy} model.
}
\examples{
if (interactive()){
# This example should be run with a higher quality model
# than the one embedded in fastrtext
library(projector)
library(fastrtext)

model_test_path <- system.file("extdata",
                               "model_unsupervised_test.bin",
                               package = "fastrtext")
model <- load_model(model_test_path)
word_embeddings <- get_word_vectors(model,
                                    words = head(get_dictionary(model), 2e5))

annoy_model <- get_annoy_model(word_embeddings, 5)
}
}
