% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_functions.R
\name{prof_mean_var_Delta}
\alias{prof_mean_var_Delta}
\title{Profile extrema for the mean and variance functions of difference process}
\usage{
prof_mean_var_Delta(kmModel, simupoints, allPsi = NULL,
  options_full_sims = NULL, options_approx = NULL, F.mat = NULL,
  T.mat = NULL)
}
\arguments{
\item{kmModel}{the \link[DiceKriging]{km} model of the Gaussian process \eqn{Z}.}

\item{simupoints}{the matrix \eqn{l x d} containing the pilot points \eqn{G}.}

\item{allPsi}{optional list of matrices (dim \eqn{pxd}) for which to compute the profile extrema. If NULL coordinate profiles are computed.}

\item{options_full_sims}{an optional list of options for \link{getAllMaxMin}(or \link{approxProfileExtrema} if \code{allPsi} not NULL). If NULL the full computations are not excuted. NOTE: this computations might be very expensive!}

\item{options_approx}{an optional list of options for \link{approxMaxMin} (or \link{approxProfileExtrema} if \code{allPsi} not NULL).}

\item{F.mat}{the evaluation of the trend function at \code{rbind(kmModel@X,simupoints)}, see \link[stats]{model.matrix}, if \code{NULL} it is computed.}

\item{T.mat}{the upper triangular factor of the Choleski decomposition of the covariance matrix of \code{rbind(kmModel@X,simupoints)}, if \code{NULL} it is computed.}
}
\value{
the profile extrema functions at \code{options_approx$design} for the mean and variance function of the difference process \eqn{Z^\Delta = Z_x - \widetilde{Z}_x}.
}
\description{
The function prof_mean_var_Delta computes the profile extrema functions for the mean and variance functions of the difference process \eqn{Z_x - \widetilde{Z}_x} at \code{x}.
}
\author{
Dario Azzimonti
}
