% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsSummary2.R
\name{modelsSummary2}
\alias{modelsSummary2}
\title{Make Summary for Model Coefficients}
\usage{
modelsSummary2(
  fit,
  labels = NULL,
  prefix = "b",
  constant = "iy",
  fitlabels = NULL,
  autoPrefix = TRUE
)
}
\arguments{
\item{fit}{A list of objects of class lm}

\item{labels}{optional list}

\item{prefix}{A character}

\item{constant}{A string vector}

\item{fitlabels}{Optional. labels of models}

\item{autoPrefix}{logical}
}
\value{
A data.frame
}
\description{
Make Summary for Model Coefficients
}
\examples{
fit1=lm(mpg~wt,data=mtcars)
fit2=lm(mpg~wt*hp*vs+am,data=mtcars)
labels=list(Y="mpg",X="wt",W="hp",Z="vs")
fit=list(fit1,fit2)
modelsSummary2(fit,labels=labels)
modelsSummary2(fit,labels=labels,prefix=c("c","b"),autoPrefix=FALSE)
modelsSummary2(fit1)
}
