% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanSummary.R
\name{meanSummary}
\alias{meanSummary}
\title{Make mean summary table}
\usage{
meanSummary(
  data,
  X = NULL,
  Y = NULL,
  M = NULL,
  W = NULL,
  labels = labels,
  digits = 3,
  xlabels = NULL,
  maxylev = 6,
  mode = 1
)
}
\arguments{
\item{data}{A data.frame}

\item{X}{Name of independant variable}

\item{Y}{Name of dependant variable}

\item{M}{Name of mediator variable}

\item{W}{Name of moderator variable}

\item{labels}{A list of labels}

\item{digits}{Integer indicating the number of decimal places}

\item{xlabels}{Optional string vector}

\item{maxylev}{maximal unique length of categorical variable}

\item{mode}{integer}
}
\description{
Make mean summary table
}
\examples{
labels=list(X="cond",Y="reaction",M="pmi")
xlabels=c("Front Page","Interior Page")
meanSummary(data=pmi,labels=labels,xlabels=xlabels)
labels=list(X="frame",Y="justify",W="skeptic")
xlabels=c("Natural causes condition","Climate change condition")
meanSummary(data=disaster,labels=labels,xlabels=xlabels)
labels=list(X="protest",Y="liking",M="respappr")
meanSummary(data=protest,labels=labels)
meanSummary(data=protest,labels=labels,maxylev=2)
}
