% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{summaries}
\alias{summaries}
\title{Evaluate solutions using summary statistics}
\description{
After generating a solution to a conservation planning \code{\link[=problem]{problem()}},
it can be useful to evaluate how well it performs. These functions
can be used to evaluate a solution according to
various different summary statistics.
}
\details{
The following functions can be used to summarize the performance
of a solution to a conservation planning \code{\link[=problem]{problem()}}:

\describe{

\item{\code{\link[=eval_n_summary]{eval_n_summary()}}}{Calculate the number of planning units selected
within a solution.}

\item{\code{\link[=eval_cost_summary]{eval_cost_summary()}}}{Calculate the total cost of a solution.}

\item{\code{\link[=eval_feature_representation_summary]{eval_feature_representation_summary()}}}{Calculate how well features
are represented by a solution. This function can be used for all
problems.}

\item{\code{\link[=eval_target_coverage_summary]{eval_target_coverage_summary()}}}{Calculate how well feature
representation \link{targets} are met by a solution. This function can only be
used with problems contain \link{targets}.}

\item{\code{\link[=eval_boundary_summary]{eval_boundary_summary()}}}{Calculate the exposed boundary length
(perimeter) associated with a solution.}

\item{\code{\link[=eval_connectivity_summary]{eval_connectivity_summary()}}}{Calculate the connectivity
held within a solution using symmetric data.}

\item{\code{\link[=eval_asym_connectivity_summary]{eval_asym_connectivity_summary()}}}{Calculate the connectivity
held within a solution using asymmetric data.
}

}
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create a minimal problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(0.1) \%>\%
     add_binary_decisions() \%>\%
     add_default_solver(verbose = FALSE)

\dontrun{
# solve problem
s <- solve(p)

# evaluate number of selected planning units in solution
eval_n_summary(p, s)

# evaluate solution cost
eval_cost_summary(p, s)

# evaluate feature representation by solution
eval_feature_representation_summary(p, s)

# evaluate target coverage by solution
eval_target_coverage_summary(p, s)

# evaluate exposed boundary (perimeter) length by solution
eval_boundary_summary(p, s)

# create a symmetric connectivity matrix to describe pair-wise connectivity
# values between combinations of planning units,
# see ?connectivity_matrix for more information

# for brevity, we will do this using the cost data
# cost valuers have high connectivity between them
cm <- connectivity_matrix(sim_pu_raster, sim_pu_raster)

# evaluate connectivity of solution using symmetric data
eval_connectivity_summary(p, s, data = cm)

# create an asymmetric connectivity matrix to describe pair-wise
# connectivity values between combinations of planning units

# for brevity, we will just generate a matrix with random values
acm <- matrix(runif(ncell(sim_pu_raster) ^ 2), ncol = ncell(sim_pu_raster))

# evaluate connectivity of solution using asymmetric data
eval_asym_connectivity_summary(p, s, data = acm)

}
}
\seealso{
Other overviews: 
\code{\link{constraints}},
\code{\link{decisions}},
\code{\link{importance}},
\code{\link{objectives}},
\code{\link{penalties}},
\code{\link{portfolios}},
\code{\link{solvers}},
\code{\link{targets}}
}
\concept{overviews}
