% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_matrix.R
\name{boundary_matrix}
\alias{boundary_matrix}
\alias{boundary_matrix.Raster}
\alias{boundary_matrix.SpatialPolygons}
\alias{boundary_matrix.SpatialLines}
\alias{boundary_matrix.SpatialPoints}
\alias{boundary_matrix.sf}
\alias{boundary_matrix.default}
\title{Boundary matrix}
\usage{
boundary_matrix(x, str_tree)

\method{boundary_matrix}{Raster}(x, str_tree = FALSE)

\method{boundary_matrix}{SpatialPolygons}(x, str_tree = FALSE)

\method{boundary_matrix}{SpatialLines}(x, str_tree = FALSE)

\method{boundary_matrix}{SpatialPoints}(x, str_tree = FALSE)

\method{boundary_matrix}{sf}(x, str_tree = FALSE)

\method{boundary_matrix}{default}(x, str_tree = FALSE)
}
\arguments{
\item{x}{\code{\linkS4class{Raster}},
\code{\linkS4class{SpatialLines}},
\code{\linkS4class{SpatialPolygons}},
\code{\link[sf:sf]{sf::sf()}} object representing planning units. If \code{x} is a
\code{\linkS4class{Raster}} object then it must have only one
layer.}

\item{str_tree}{\code{logical} should a GEOS STRtree structure be used to
to pre-process data? If \code{TRUE}, then the experimental
\code{\link[rgeos:experimental-functions]{rgeos::gUnarySTRtreeQuery()}} function
will be used to pre-compute which planning units are adjacent to
each other and potentially reduce the processing time required to
generate the boundary matrices. This argument is only used when
the planning unit data are vector-based polygons (i.e.
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} objects). \strong{Note that
using \code{TRUE} may crash Mac OSX systems.} The default argument
is \code{FALSE}.}
}
\value{
\code{\linkS4class{dsCMatrix}} symmetric sparse matrix object.
Each row and column represents a planning unit.
Cells values indicate the shared boundary length between different pairs
of planning units.
}
\description{
Generate a matrix describing the amount of shared boundary length
between different planning units, and the amount of exposed edge length each
planning unit exhibits.
}
\details{
This function returns a \code{\linkS4class{dsCMatrix}}
symmetric sparse matrix. Cells on the off-diagonal indicate the length of
the shared boundary between two different planning units. Cells on the
diagonal indicate length of a given planning unit's edges that have no
neighbors (e.g. for edges of planning units found along the
coastline). \strong{This function assumes the data are in a coordinate
system where Euclidean distances accurately describe the proximity
between two points on the earth}. Thus spatial data in a longitude/latitude
coordinate system (i.e.
\href{https://spatialreference.org/ref/epsg/wgs-84/}{WGS84})
should be reprojected to another coordinate system before using this
function. Note that for \code{\linkS4class{Raster}} objects
boundaries are missing for cells that have \code{NA} values in all cells.
}
\examples{
# load data
data(sim_pu_raster, sim_pu_polygons)

# subset data to reduce processing time
r <- crop(sim_pu_raster, c(0, 0.3, 0, 0.3))
ply <- sim_pu_polygons[c(1:2, 10:12, 20:22), ]
ply2 <- st_as_sf(ply)

# create boundary matrix using raster data
bm_raster <- boundary_matrix(r)

# create boundary matrix using polygon (Spatial) data
bm_ply1 <- boundary_matrix(ply)

# create boundary matrix using polygon (sf) data
bm_ply2 <- boundary_matrix(ply2)

# create boundary matrix with polygon (Spatial) data and GEOS STR query trees
# to speed up processing
bm_ply3 <- boundary_matrix(ply, TRUE)

# plot raster and boundary matrix
\dontrun{
par(mfrow = c(1, 2))
plot(r, main = "raster", axes = FALSE, box = FALSE)
plot(raster(as.matrix(bm_raster)), main = "boundary matrix",
     axes = FALSE, box = FALSE)
}
# plot polygons and boundary matrices
\dontrun{
par(mfrow = c(1, 3))
plot(r, main = "polygons (Spatial)", axes = FALSE, box = FALSE)
plot(raster(as.matrix(bm_ply1)), main = "boundary matrix", axes = FALSE,
     box = FALSE)
plot(r, main = "polygons (sf)", axes = FALSE, box = FALSE)
plot(raster(as.matrix(bm_ply2)), main = "boundary matrix", axes = FALSE,
     box = FALSE)
plot(raster(as.matrix(bm_ply3)), main = "boundary matrix (Spatial, STR)",
            axes = FALSE, box = FALSE)
}
}
