% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_target_coverage_summary.R
\name{eval_target_coverage_summary}
\alias{eval_target_coverage_summary}
\alias{eval_target_coverage_summary,ConservationProblem,numeric-method}
\alias{eval_target_coverage_summary,ConservationProblem,matrix-method}
\alias{eval_target_coverage_summary,ConservationProblem,data.frame-method}
\alias{eval_target_coverage_summary,ConservationProblem,Spatial-method}
\alias{eval_target_coverage_summary,ConservationProblem,sf-method}
\alias{eval_target_coverage_summary,ConservationProblem,Raster-method}
\alias{eval_target_coverage_summary.default}
\alias{eval_target_coverage_summary.ConservationProblem}
\title{Evaluate target coverage}
\usage{
eval_target_coverage_summary(x, solution, include_zone, include_sense)

\method{eval_target_coverage_summary}{default}(x, solution, include_zone, include_sense)

\method{eval_target_coverage_summary}{ConservationProblem}(
  x,
  solution,
  include_zone = number_of_zones(x) > 1,
  include_sense = number_of_zones(x) > 1
)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{solution}{\code{numeric}, \code{matrix}, \code{data.frame},
\code{\linkS4class{Raster}}, \code{\linkS4class{Spatial}},
or \code{\link[sf:sf]{sf::sf()}} object.
The argument should be in the same format as the planning unit cost
data in the argument to \code{x}.
See the Solution format section for more information.}

\item{include_zone}{\code{logical} include the \code{zone} column in the output?
Defaults to \code{TRUE} for problems that contain multiple zones.}

\item{include_sense}{\code{logical} include the \code{sense} column in the output?
Defaults to \code{TRUE} for problems that contain multiple zones.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble()}} object.
Here, each row describes information for a different target.
It contains the following columns:

\describe{

\item{feature}{\code{character} name of the feature associated with each
target.}

\item{zone}{\code{list} of \code{character} zone names associated with each target.
This column is in a list-column format because a single target can
correspond to multiple zones (see \code{\link[=add_manual_targets]{add_manual_targets()}} for details
and examples).
For an example of converting the list-column format to a standard
\code{character} column format, please see the Examples section.
This column is only included if the argument to \code{include_zones}
is \code{TRUE}.}

\item{sense}{\code{character} sense associated with each target.
Sense values specify the nature of the target.
Typically (e.g. when using the \code{\link[=add_absolute_targets]{add_absolute_targets()}} or
\code{\link[=add_relative_targets]{add_relative_targets()}} functions), targets are specified using sense
values indicating that the total amount of a feature held within a
solution (ideally) be greater than or equal to a threshold amount
(i.e. a  sense value of \code{">="}).
Additionally, targets (i.e. using the \code{\link[=add_manual_targets]{add_manual_targets()}} function)
can also be specified using sense values indicating that the total
amount of a feature held within a solution must be equal to a
threshold amount (i.e. a sense value of \code{"="}) or smaller than or equal
to a threshold amount (i.e. a sense value of \code{"<="}).
This column is only included if the argument to \code{include_sense} is
\code{TRUE}.}

\item{total_amount}{\code{numeric} total amount of the feature available across
the entire conservation planning problem for meeting each target
(not just planning units selected within the solution).
For problems involving a single zone, this column is calculated
as the sum of all of the values for a given feature
(similar to values in the \code{total_amount} column produced by the
\code{\link[=eval_feature_representation_summary]{eval_feature_representation_summary()}} function).
For problems involving multiple zones,
this column is calculated as the sum of the values for the
feature associated with target (per the \code{"feature"} column),
across the zones associated with the target (per the \code{"zone"} column).}

\item{absolute_target}{\code{numeric} total threshold amount associated with
each target.}

\item{absolute_held}{\code{numeric} total amount held within the solution for
the feature and (if relevant) zones associated with each target (per the
\code{"feature"} and \code{"zone"} columns, respectively).
This column is calculated as the sum of the feature data,
supplied when creating a \code{\link[=problem]{problem()}} object
(e.g. presence/absence values), weighted by the status of each
planning unit in the solution (e.g. selected or not for prioritization).}

\item{absolute_shortfall}{ \code{numeric} total amount by which the solution
fails to meet each target.
This column is calculated as the difference between the total amount
held within the solution for the feature and (if relevant) zones
associated with the target (i.e. \code{"absolute_held"} column) and the
target total threshold amount (i.e. \code{"absolute_target"} column), with
values set to zero depending on the sense specified for the target
(e.g. if the target sense is \code{>=} then the difference is
set to zero if the value in the \code{"absolute_held"} is smaller than
that in the \code{"absolute_target"} column).}

\item{relative_target}{\code{numeric} proportion threshold amount associated
with each target.
This column is calculated by dividing the total threshold amount
associated with each target (i.e. \code{"absolute_target"} column) by
the total amount associated with each target
(i.e. \code{"total_amount"} column).}

\item{relative_held}{\code{numeric} proportion held within the solution for the
feature and (if relevant) zones associated with each target (per the
\code{"feature"} and \code{"zone"} columns, respectively).
This column is calculated by dividing the total amount held
for each target (i.e. \code{"absolute_held"} column) by the
total amount for with each target
(i.e. \code{"total_amount"} column).}

\item{relative_shortfall}{\code{numeric} proportion by which the solution fails
to meet each target.
This column is calculated by dividing the total shortfall for
each target (i.e. \code{"absolute_shortfall"} column) by the
total amount for each target (i.e. \code{"total_amount"} column).}

\item{met}{\code{logical} indicating if each target is met by the solution. This
column is calculated by checking if the total shortfall associated
with each target (i.e. \verb{"absolute_shortfall}" column) is equal to
zero.}

}
}
\description{
Calculate how well feature representation \link{targets} are met by a solution to
a conservation planning \code{\link[=problem]{problem()}}.
It is useful for understanding if features are adequately represented by
a solution.
Note that this function can only be used with problems that contain
\link{targets}.
}
\section{Solution format}{

Broadly speaking, the argument to \code{solution} must be in the same format as
the planning unit data in the argument to \code{x}.
Further details on the correct format are listed separately
for each of the different planning unit data formats:

\describe{

\item{\code{x} has \code{numeric} planning units}{The argument to \code{solution} must be a
\code{numeric} vector with each element corresponding to a different planning
unit. It should have the same number of planning units as those
in the argument to \code{x}. Additionally, any planning units missing
cost (\code{NA}) values should also have missing (\code{NA}) values in the
argument to \code{solution}.
}

\item{\code{x} has \code{matrix} planning units}{The argument to \code{solution} must be a
\code{matrix} vector with each row corresponding to a different planning
unit, and each column correspond to a different management zone.
It should have the same number of planning units and zones
as those in the argument to \code{x}. Additionally, any planning units
missing cost (\code{NA}) values for a particular zone should also have a
missing (\code{NA}) values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Raster}} planning units}{The argument to \code{solution}
be a \code{\linkS4class{Raster}} object where different grid cells (pixels) correspond
to different planning units and layers correspond to
a different management zones. It should have the same dimensionality
(rows, columns, layers), resolution, extent, and coordinate reference
system as the planning units in the argument to \code{x}. Additionally,
any planning units missing cost (\code{NA}) values for a particular zone
should also have missing (\code{NA})  values in the argument to \code{solution}.
}

\item{\code{x} has \code{data.frame} planning units}{The argument to \code{solution} must
be a \code{data.frame} with each column corresponding to a different zone,
each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if a \code{data.frame}
object containing the solution also contains additional columns, then
these columns will need to be subsetted prior to using this function
(see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Spatial}} planning units}{The argument to \code{solution}
must be a \code{\linkS4class{Spatial}} object with each column corresponding to a
different zone, each row corresponding to a different planning unit, and
cell values corresponding to the solution value. This means that if the
\code{\linkS4class{Spatial}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\link[sf:sf]{sf::sf()}} planning units}{The argument to \code{solution} must be
a \code{\link[sf:sf]{sf::sf()}} object with each column corresponding to a different
zone, each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if the
\code{\link[sf:sf]{sf::sf()}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}
}
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_pu_sf, sim_features,
     sim_pu_zones_sf, sim_features_zones)

# build minimal conservation problem with raster data
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(verbose = FALSE)

# solve the problem
s1 <- solve(p1)

# print solution
print(s1)

# plot solution
plot(s1, main = "solution", axes = FALSE, box = FALSE)

# calculate target coverage by the solution
r1 <- eval_target_coverage_summary(p1, s1)
print(r1, width = Inf) # note: `width = Inf` tells R to print all columns

# build minimal conservation problem with polygon (sf) data
p2 <- problem(sim_pu_sf, sim_features, cost_column = "cost") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(verbose = FALSE)

# solve the problem
s2 <- solve(p2)

# print first six rows of the attribute table
print(head(s2))

# plot solution
plot(s2[, "solution_1"])

# calculate target coverage by the solution
r2 <- eval_target_coverage_summary(p2, s2[, "solution_1"])
print(r2, width = Inf)

# build multi-zone conservation problem with polygon (sf) data
p3 <- problem(sim_pu_zones_sf, sim_features_zones,
              cost_column = c("cost_1", "cost_2", "cost_3")) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(verbose = FALSE)

# solve the problem
s3 <- solve(p3)

# print first six rows of the attribute table
print(head(s3))

# create new column representing the zone id that each planning unit
# was allocated to in the solution
s3$solution <- category_vector(
  s3[, c("solution_1_zone_1", "solution_1_zone_2", "solution_1_zone_3")])
s3$solution <- factor(s3$solution)

# plot solution
plot(s3[, "solution"])

# calculate target coverage by the solution
r3 <- eval_target_coverage_summary(
  p3, s3[, c("solution_1_zone_1", "solution_1_zone_2", "solution_1_zone_3")])
print(r3, width = Inf)

# create a new column with character values containing the zone names,
# by extracting these data out of the zone column
# (which is in list-column format)
r3$zone2 <- vapply(r3$zone, FUN.VALUE = character(1), paste, sep = " & ")

# print r3 again to show the new column
print(r3, width = Inf)
}
}
\seealso{
\code{\link[=problem]{problem()}}, \link{summaries}.
}
