% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solver-proto.R
\name{Solver-class}
\alias{Solver-class}
\alias{Solver}
\title{Solver prototype}
\description{
This prototype is used to generate objects that represent methods for solving
optimization problems. \strong{This class represents a recipe to
create solver and and is only recommended for use by expert users. To
customize the method used to solve optimization problems, please see the
help page on \code{\link{solvers}}}.
}
\section{Fields}{


\describe{

\item{$name}{\code{character} name of solver.}

\item{$data}{\code{list} object optimization problem data.}

\item{$parameters}{\code{Parameters} object with parameters used to customize
  the the solver.}

\item{$solve}{\code{function} used to solve a
  \code{\link{OptimizationProblem-class}} object.}
}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$get_data(name)}

\code{x$set_data(name, value)}

\code{x$set_variable_ub(index, value)}

\code{x$set_variable_lb(index, value)}

\code{x$calculate(op)}

\code{x$run()}

\code{x$solve(op)}
}

\section{Arguments}{

\describe{

\item{x}{\code{\link{Solver-class}} object.}

\item{op}{\code{\link{OptimizationProblem-class}} object.}

}
}

\section{Details}{


\describe{
\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{get_data}{return an object stored in the \code{data} field with
  the corresponding \code{name}. If the object is not present in the
  \code{data} field, a \code{waiver} object is returned.}

\item{set_data}{store an object stored in the \code{data} field with
  the corresponding name. If an object with that name already
  exists then the object is overwritten.}

\item{set_variable_ub}{set the upper bounds on decision variables in
  a pre-calculated optimization problem stored in the solver.}

\item{set_variable_lb}{set the lower bounds on decision variables in
  a pre-calculated optimization problem stored in the solver.}
\item{calculate}{ingest a general purpose
  \code{\link{OptimizationProblem-class}} object and convert it to the
  correct format for the solver.}
\item{run}{run the solver and output a solution}

\item{solve}{solve an \code{\link{OptimizationProblem-class}} using this
  object.}

}
}

